/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.CIMOperatingSystem;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.Volume;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.savvis.vpdc.VPDCClient;
import org.jclouds.savvis.vpdc.domain.Link;
import org.jclouds.savvis.vpdc.domain.Network;
import org.jclouds.savvis.vpdc.domain.Org;
import org.jclouds.savvis.vpdc.domain.Resource;
import org.jclouds.savvis.vpdc.domain.Task;
import org.jclouds.savvis.vpdc.domain.VDC;
import org.jclouds.savvis.vpdc.domain.VM;
import org.jclouds.savvis.vpdc.domain.VMSpec;
import org.jclouds.savvis.vpdc.options.GetVMOptions;
import org.jclouds.savvis.vpdc.predicates.TaskSuccess;

@Singleton
public class VPDCComputeServiceAdapter
implements ComputeServiceAdapter<VM, VMSpec, CIMOperatingSystem, Network> {
    private final VPDCClient client;
    private final RetryablePredicate<String> taskTester;
    @Inject(optional=true)
    @Named(value="savvis-symphonyvpdc.vdc-email")
    String email;

    @Inject
    public VPDCComputeServiceAdapter(VPDCClient client, TaskSuccess taskSuccess) {
        this.client = (VPDCClient)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.taskTester = new RetryablePredicate((Predicate)Preconditions.checkNotNull((Object)taskSuccess, (Object)"taskSuccess"), 650L, 10L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComputeServiceAdapter.NodeAndInitialCredentials<VM> createNodeWithGroupEncodedIntoName(String tag, String name, Template template) {
        String networkTierName = template.getLocation().getId();
        String vpdcId = template.getLocation().getParent().getId();
        String billingSiteId = template.getLocation().getParent().getParent().getId();
        VMSpec.Builder specBuilder = VMSpec.builder();
        specBuilder.name(name);
        specBuilder.networkTierName(networkTierName);
        specBuilder.operatingSystem((CIMOperatingSystem)CIMOperatingSystem.class.cast(template.getImage().getOperatingSystem()));
        specBuilder.processorCount(template.getHardware().getProcessors().size());
        specBuilder.memoryInGig(template.getHardware().getRam() / 1024);
        for (Volume volume : template.getHardware().getVolumes()) {
            if (volume.isBootDevice()) {
                specBuilder.bootDeviceName(volume.getDevice()).bootDiskSize(volume.getSize().intValue());
                continue;
            }
            specBuilder.addDataDrive(volume.getDevice(), volume.getSize().intValue());
        }
        Task task = this.client.getVMClient().addVMIntoVDC(billingSiteId, vpdcId, specBuilder.build());
        if (task.getError() != null) {
            throw new RuntimeException("cloud not add vm: " + task.getError().toString());
        }
        if (this.taskTester.apply((Object)task.getId())) {
            VM returnVal = this.getNode(task.getResult().getHref().toASCIIString());
            ComputeServiceAdapter.NodeAndInitialCredentials nodeAndInitialCredentials = new ComputeServiceAdapter.NodeAndInitialCredentials((Object)returnVal, returnVal.getId(), null);
            return nodeAndInitialCredentials;
        }
        throw new RuntimeException("task timed out: " + task);
    }

    public Iterable<VMSpec> listHardwareProfiles() {
        return ImmutableSet.of((Object)VMSpec.builder().operatingSystem((CIMOperatingSystem)Iterables.get(this.listImages(), (int)0)).memoryInGig(2).addDataDrive("/data01", 25).build());
    }

    public Iterable<CIMOperatingSystem> listImages() {
        return this.client.listPredefinedOperatingSystems();
    }

    public Iterable<VM> listNodes() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Resource org1 : this.client.listOrgs()) {
            Org org = this.client.getBrowsingClient().getOrg(org1.getId());
            for (Link vdc : org.getVDCs()) {
                VDC VDC2 = this.client.getBrowsingClient().getVDCInOrg(org.getId(), vdc.getId());
                for (Resource vApp : Iterables.filter(VDC2.getResourceEntities(), (Predicate)new Predicate<Resource>(){

                    public boolean apply(Resource arg0) {
                        return "application/vnd.vmware.vcloud.vApp+xml".equals(arg0.getType());
                    }
                })) {
                    builder.add((Object)this.client.getBrowsingClient().getVMInVDC(org.getId(), vdc.getId(), vApp.getId(), GetVMOptions.Builder.withPowerState()));
                }
            }
        }
        return builder.build();
    }

    public Iterable<Network> listLocations() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Resource org1 : this.client.listOrgs()) {
            Org org = this.client.getBrowsingClient().getOrg(org1.getId());
            for (Link vdc : org.getVDCs()) {
                VDC VDC2 = this.client.getBrowsingClient().getVDCInOrg(org.getId(), vdc.getId());
                if (this.email != null && VDC2.getDescription().indexOf(this.email) != -1) continue;
                for (Resource network : VDC2.getAvailableNetworks()) {
                    builder.add((Object)this.client.getBrowsingClient().getNetworkInVDC(org.getId(), vdc.getId(), network.getId()));
                }
            }
        }
        return builder.build();
    }

    public VM getNode(String id) {
        return this.client.getBrowsingClient().getVM(URI.create((String)Preconditions.checkNotNull((Object)id, (Object)"id")), GetVMOptions.Builder.withPowerState());
    }

    public void destroyNode(String id) {
        this.taskTester.apply((Object)this.client.getVMClient().removeVM(URI.create((String)Preconditions.checkNotNull((Object)id, (Object)"id"))).getId());
    }

    public void rebootNode(String id) {
        this.suspendNode(id);
        this.resumeNode(id);
    }

    public void resumeNode(String id) {
        this.taskTester.apply((Object)this.client.getServiceManagementClient().powerOnVM(URI.create((String)Preconditions.checkNotNull((Object)id, (Object)"id"))).getId());
    }

    public void suspendNode(String id) {
        this.taskTester.apply((Object)this.client.getServiceManagementClient().powerOffVM(URI.create((String)Preconditions.checkNotNull((Object)id, (Object)"id"))).getId());
    }
}

