/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.compute.suppliers;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;

@Singleton
public class FirstNetwork
implements Supplier<Location> {
    private final Supplier<Set<? extends Location>> locationsSupplier;
    private final IsNetwork isNetwork;

    @Inject
    FirstNetwork(@Memoized Supplier<Set<? extends Location>> locationsSupplier, IsNetwork isNetwork) {
        this.locationsSupplier = (Supplier)Preconditions.checkNotNull(locationsSupplier, (Object)"locationsSupplierSupplier");
        this.isNetwork = (IsNetwork)Preconditions.checkNotNull((Object)isNetwork, (Object)"isNetwork");
    }

    public Location get() {
        return (Location)Iterables.find((Iterable)((Iterable)this.locationsSupplier.get()), (Predicate)this.isNetwork);
    }

    @Singleton
    public static final class IsNetwork
    implements Predicate<Location> {
        public boolean apply(Location input) {
            return input.getScope() == LocationScope.NETWORK;
        }

        public String toString() {
            return "isNetwork()";
        }
    }
}

