/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.config;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.CIMOperatingSystem;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.json.Json;
import org.jclouds.location.Provider;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.rest.AsyncClientFactory;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.config.RestClientModule;
import org.jclouds.rest.suppliers.MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier;
import org.jclouds.savvis.vpdc.VPDCAsyncClient;
import org.jclouds.savvis.vpdc.VPDCClient;
import org.jclouds.savvis.vpdc.domain.Resource;
import org.jclouds.savvis.vpdc.domain.internal.VCloudSession;
import org.jclouds.savvis.vpdc.features.BrowsingAsyncClient;
import org.jclouds.savvis.vpdc.features.BrowsingClient;
import org.jclouds.savvis.vpdc.features.FirewallAsyncClient;
import org.jclouds.savvis.vpdc.features.FirewallClient;
import org.jclouds.savvis.vpdc.features.ServiceManagementAsyncClient;
import org.jclouds.savvis.vpdc.features.ServiceManagementClient;
import org.jclouds.savvis.vpdc.features.VMAsyncClient;
import org.jclouds.savvis.vpdc.features.VMClient;
import org.jclouds.savvis.vpdc.handlers.VPDCErrorHandler;
import org.jclouds.savvis.vpdc.internal.LoginAsyncClient;
import org.jclouds.savvis.vpdc.internal.Org;
import org.jclouds.savvis.vpdc.internal.VCloudToken;
import org.jclouds.savvis.vpdc.predicates.TaskSuccess;
import org.jclouds.util.Strings2;

public class VPDCRestClientModule
extends RestClientModule<VPDCClient, VPDCAsyncClient> {
    protected AtomicReference<AuthorizationException> authException = new AtomicReference();
    public static final Map<Class<?>, Class<?>> DELEGATE_MAP = ImmutableMap.builder().put(BrowsingClient.class, BrowsingAsyncClient.class).put(VMClient.class, VMAsyncClient.class).put(FirewallClient.class, FirewallAsyncClient.class).put(ServiceManagementClient.class, ServiceManagementAsyncClient.class).build();

    @Provides
    @Singleton
    protected LoginAsyncClient provideVCloudVersions(AsyncClientFactory factory) {
        return (LoginAsyncClient)factory.create(LoginAsyncClient.class);
    }

    @VCloudToken
    @Provides
    String provideVCloudToken(Supplier<VCloudSession> cache) {
        return (String)Preconditions.checkNotNull((Object)((VCloudSession)cache.get()).getVCloudToken(), (Object)"No token present in session");
    }

    @Provides
    @Org
    @Singleton
    protected Set<Resource> provideOrgs(Supplier<VCloudSession> cache, @Named(value="jclouds.identity") String user) {
        VCloudSession discovery = (VCloudSession)cache.get();
        Preconditions.checkState((discovery.getOrgs().size() > 0 ? 1 : 0) != 0, (Object)("No orgs present for user: " + user));
        return discovery.getOrgs();
    }

    @Provides
    @Org
    @Singleton
    protected String provideDefaultOrgId(@Org Set<Resource> orgs) {
        return ((Resource)Iterables.get(orgs, (int)0)).getId();
    }

    @Provides
    @Singleton
    protected Predicate<String> successTester(Injector injector, @Named(value="jclouds.vpdc.timeout.task-complete") long completed) {
        return new RetryablePredicate((Predicate)injector.getInstance(TaskSuccess.class), completed);
    }

    public VPDCRestClientModule() {
        super(VPDCClient.class, VPDCAsyncClient.class, DELEGATE_MAP);
    }

    @Singleton
    @Provides
    protected Set<CIMOperatingSystem> provideOperatingSystems(Json json, @Provider String providerName) throws IOException {
        return (Set)json.fromJson(Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/" + providerName + "/predefined_operatingsystems.json")), new TypeLiteral<Set<CIMOperatingSystem>>(){}.getType());
    }

    @Provides
    @Singleton
    protected Supplier<VCloudSession> provideVCloudTokenCache(@Named(value="jclouds.session-interval") long seconds, final LoginAsyncClient login) {
        return new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier(this.authException, seconds, (Supplier)new Supplier<VCloudSession>(){

            public VCloudSession get() {
                try {
                    return (VCloudSession)login.login().get(10L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    Throwables.propagate((Throwable)e);
                    assert (false) : e;
                    return null;
                }
            }
        });
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(VPDCErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(VPDCErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(VPDCErrorHandler.class);
    }
}

