/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.domain;

import java.net.URI;
import org.jclouds.savvis.vpdc.domain.ResourceImpl;

public class FirewallRule
extends ResourceImpl {
    private final String firewallType;
    private final boolean isEnabled;
    private final String source;
    private final String destination;
    private final String port;
    private final String policy;
    private final String description;
    private final boolean isLogged;
    private final String protocol;

    public static Builder builder() {
        return new Builder();
    }

    public FirewallRule(String id, String name, String type, URI href, String firewallType, boolean isEnabled, String source, String destination, String port, String policy, String description, boolean isLogged, String protocol) {
        super(id, name, type, href);
        this.firewallType = firewallType;
        this.isEnabled = isEnabled;
        this.source = source;
        this.destination = destination;
        this.port = port;
        this.policy = policy;
        this.description = description;
        this.isLogged = isLogged;
        this.protocol = protocol;
    }

    @Override
    public Builder toBuilder() {
        return Builder.fromFirewallRule(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FirewallRule other = (FirewallRule)obj;
        if (this.firewallType == null ? other.firewallType != null : !this.firewallType.equals(other.firewallType)) {
            return false;
        }
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        if (this.destination == null ? other.destination != null : !this.destination.equals(other.destination)) {
            return false;
        }
        if (this.port == null ? other.port != null : !this.port.equals(other.port)) {
            return false;
        }
        if (this.policy == null ? other.policy != null : !this.policy.equals(other.policy)) {
            return false;
        }
        return !(this.protocol == null ? other.protocol != null : !this.protocol.equals(other.protocol));
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public String getSource() {
        return this.source;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getFirewallType() {
        return this.firewallType;
    }

    public String getPort() {
        return this.port;
    }

    public String getPolicy() {
        return this.policy;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isLogged() {
        return this.isLogged;
    }

    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public String toString() {
        return "[firewallType=" + this.firewallType + ", description=" + this.description + ", source=" + this.source + ", destination=" + this.destination + ", port=" + this.port + ", protocol=" + this.protocol + ", policy=" + this.policy + ", isLogged=" + this.isLogged;
    }

    public static class Builder
    extends ResourceImpl.Builder {
        private String firewallType;
        private boolean isEnabled;
        private String source;
        private String destination;
        private String port;
        private String policy;
        private String description;
        private boolean isLogged;
        private String protocol;

        @Override
        public FirewallRule build() {
            return new FirewallRule(this.id, this.name, this.type, this.href, this.firewallType, this.isEnabled, this.source, this.destination, this.port, this.policy, this.description, this.isLogged, this.protocol);
        }

        public Builder firewallType(String firewallType) {
            this.firewallType = firewallType;
            return this;
        }

        public Builder isEnabled(boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            return this;
        }

        public Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public Builder port(String port) {
            this.port = port;
            return this;
        }

        public Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder isLogged(boolean isLogged) {
            this.isLogged = isLogged;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public static Builder fromFirewallRule(FirewallRule in) {
            return new Builder().id(in.getId()).name(in.getName()).type(in.getType()).href(in.getHref()).firewallType(in.getFirewallType()).isEnabled(in.isEnabled()).source(in.getSource()).destination(in.getDestination()).port(in.getPort()).policy(in.getPolicy()).description(in.getDescription()).isLogged(in.isLogged()).protocol(in.getProtocol());
        }

        @Override
        public Builder id(String id) {
            return (Builder)Builder.class.cast(super.id(id));
        }

        @Override
        public Builder name(String name) {
            return (Builder)Builder.class.cast(super.name(name));
        }

        @Override
        public Builder type(String type) {
            return (Builder)Builder.class.cast(super.type(type));
        }

        @Override
        public Builder href(URI href) {
            return (Builder)Builder.class.cast(super.href(href));
        }
    }
}

