/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import org.jclouds.savvis.vpdc.domain.FirewallRule;
import org.jclouds.savvis.vpdc.domain.ResourceImpl;

public class FirewallService
extends ResourceImpl {
    private final boolean isEnabled;
    private final Set<FirewallRule> firewallRules;

    public static Builder builder() {
        return new Builder();
    }

    public FirewallService(String id, String name, String type, URI href, boolean isEnabled, Set<FirewallRule> firewallRules) {
        super(id, name, type, href);
        this.isEnabled = isEnabled;
        this.firewallRules = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(firewallRules, (Object)"firewallRules")));
    }

    @Override
    public Builder toBuilder() {
        return Builder.fromFirewallService(this);
    }

    public Set<FirewallRule> getFirewallRules() {
        return this.firewallRules;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public static class Builder
    extends ResourceImpl.Builder {
        private boolean isEnabled;
        private Set<FirewallRule> firewallRules = Sets.newLinkedHashSet();

        @Override
        public FirewallService build() {
            return new FirewallService(this.id, this.name, this.type, this.href, this.isEnabled, this.firewallRules);
        }

        public Builder isEnabled(boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        public Builder firewallRule(FirewallRule in) {
            this.firewallRules.add((FirewallRule)Preconditions.checkNotNull((Object)in, (Object)"firewallRule"));
            return this;
        }

        public Builder firewallRules(Set<FirewallRule> firewallRules) {
            this.firewallRules.addAll((Collection)Preconditions.checkNotNull(firewallRules, (Object)"firewallRules"));
            return this;
        }

        public static Builder fromFirewallService(FirewallService in) {
            return new Builder().id(in.getId()).name(in.getName()).type(in.getType()).href(in.getHref()).isEnabled(in.isEnabled()).firewallRules(in.getFirewallRules());
        }

        @Override
        public Builder id(String id) {
            return (Builder)Builder.class.cast(super.id(id));
        }

        @Override
        public Builder name(String name) {
            return (Builder)Builder.class.cast(super.name(name));
        }

        @Override
        public Builder type(String type) {
            return (Builder)Builder.class.cast(super.type(type));
        }

        @Override
        public Builder href(URI href) {
            return (Builder)Builder.class.cast(super.href(href));
        }
    }
}

