/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.savvis.vpdc.domain.ResourceImpl;

public class Network
extends ResourceImpl {
    @Nullable
    private final String gateway;
    private final String netmask;
    private final Map<String, String> internalToExternalNATRules;

    public static Builder builder() {
        return new Builder();
    }

    public Network(String id, String name, String type, URI href, @Nullable String gateway, String netmask, Map<String, String> internalToExternalNATRules) {
        super(id, name, type, href);
        this.gateway = gateway;
        this.netmask = netmask;
        this.internalToExternalNATRules = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(internalToExternalNATRules, (Object)"internalToExternalNATRules")));
    }

    public String getGateway() {
        return this.gateway;
    }

    public String getNetmask() {
        return this.netmask;
    }

    public Map<String, String> getInternalToExternalNATRules() {
        return this.internalToExternalNATRules;
    }

    @Override
    public Builder toBuilder() {
        return Builder.fromNetwork(this);
    }

    @Override
    public String toString() {
        return "[id=" + this.id + ", href=" + this.href + ", name=" + this.name + ", type=" + this.type + ", gateway=" + this.gateway + ", netmask=" + this.netmask + ", internalToExternalNATRules=" + this.internalToExternalNATRules + "]";
    }

    public static class Builder
    extends ResourceImpl.Builder {
        private String gateway;
        private String netmask;
        private Map<String, String> internalToExternalNATRules = Maps.newLinkedHashMap();

        public Builder gateway(String gateway) {
            this.gateway = gateway;
            return this;
        }

        public Builder netmask(String netmask) {
            this.netmask = netmask;
            return this;
        }

        public Builder internalToExternalNATRule(String internalIP, String externalIP) {
            this.internalToExternalNATRules.put((String)Preconditions.checkNotNull((Object)internalIP, (Object)"internalIP"), (String)Preconditions.checkNotNull((Object)externalIP, (Object)"externalIP"));
            return this;
        }

        public Builder internalToExternalNATRules(Map<String, String> internalToExternalNATRules) {
            this.internalToExternalNATRules.putAll((Map)Preconditions.checkNotNull(internalToExternalNATRules, (Object)"internalToExternalNATRules"));
            return this;
        }

        @Override
        public Network build() {
            return new Network(this.id, this.name, this.type, this.href, this.gateway, this.netmask, this.internalToExternalNATRules);
        }

        public static Builder fromNetwork(Network in) {
            return new Builder().id(in.getId()).name(in.getName()).type(in.getType()).href(in.getHref()).gateway(in.getGateway()).internalToExternalNATRules(in.getInternalToExternalNATRules()).netmask(in.getNetmask());
        }

        @Override
        public Builder id(String id) {
            return (Builder)Builder.class.cast(super.id(id));
        }

        @Override
        public Builder name(String name) {
            return (Builder)Builder.class.cast(super.name(name));
        }

        @Override
        public Builder type(String type) {
            return (Builder)Builder.class.cast(super.type(type));
        }

        @Override
        public Builder href(URI href) {
            return (Builder)Builder.class.cast(super.href(href));
        }
    }
}

