/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.jclouds.ovf.Section;

public class NetworkConfigSection
extends Section<NetworkConfigSection> {
    private final String network;
    private final String fenceMode;
    private final Boolean dhcp;
    private final String gateway;
    private final String netmask;
    private final Map<String, String> internalToExternalNATRules;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return NetworkConfigSection.builder().fromNetworkConfigSection(this);
    }

    public NetworkConfigSection(String info, String network, String fenceMode, Boolean dhcp, String gateway, String netmask, Map<String, String> internalToExternalNATRules) {
        super(info);
        this.network = network;
        this.fenceMode = fenceMode;
        this.dhcp = dhcp;
        this.gateway = gateway;
        this.netmask = netmask;
        this.internalToExternalNATRules = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(internalToExternalNATRules, (Object)"internalToExternalNATRules")));
    }

    public String getGateway() {
        return this.gateway;
    }

    public String getNetmask() {
        return this.netmask;
    }

    public Map<String, String> getInternalToExternalNATRules() {
        return this.internalToExternalNATRules;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getFenceMode() {
        return this.fenceMode;
    }

    public Boolean getDhcp() {
        return this.dhcp;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.network == null ? 0 : this.network.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        NetworkConfigSection other = (NetworkConfigSection)((Object)obj);
        return !(this.network == null ? other.network != null : !this.network.equals(other.network));
    }

    public String toString() {
        return String.format("[info=%s, network=%s, dhcp=%s, fenceMode=%s, gateway=%s, internalToExternalNATRules=%s, netmask=%s]", this.info, this.network, this.dhcp, this.fenceMode, this.gateway, this.internalToExternalNATRules, this.netmask);
    }

    public static class Builder
    extends Section.Builder<NetworkConfigSection> {
        private String network;
        private String fenceMode;
        private Boolean dhcp;
        private String gateway;
        private String netmask;
        private Map<String, String> internalToExternalNATRules = Maps.newLinkedHashMap();

        public Builder network(String network) {
            this.network = network;
            return this;
        }

        public Builder fenceMode(String fenceMode) {
            this.fenceMode = fenceMode;
            return this;
        }

        public Builder dhcp(Boolean dhcp) {
            this.dhcp = dhcp;
            return this;
        }

        public Builder gateway(String gateway) {
            this.gateway = gateway;
            return this;
        }

        public Builder netmask(String netmask) {
            this.netmask = netmask;
            return this;
        }

        public Builder internalToExternalNATRule(String internalIP, String externalIP) {
            this.internalToExternalNATRules.put((String)Preconditions.checkNotNull((Object)internalIP, (Object)"internalIP"), (String)Preconditions.checkNotNull((Object)externalIP, (Object)"externalIP"));
            return this;
        }

        public Builder internalToExternalNATRules(Map<String, String> internalToExternalNATRules) {
            this.internalToExternalNATRules.putAll((Map)Preconditions.checkNotNull(internalToExternalNATRules, (Object)"internalToExternalNATRules"));
            return this;
        }

        public NetworkConfigSection build() {
            return new NetworkConfigSection(this.info, this.network, this.fenceMode, this.dhcp, this.gateway, this.netmask, this.internalToExternalNATRules);
        }

        public Builder fromNetworkConfigSection(NetworkConfigSection in) {
            return this.fromSection(in).network(in.getNetwork()).fenceMode(in.getFenceMode()).dhcp(in.getDhcp()).gateway(in.getGateway()).netmask(in.getNetmask()).internalToExternalNATRules(in.getInternalToExternalNATRules());
        }

        public Builder fromSection(Section<NetworkConfigSection> in) {
            return (Builder)((Object)Builder.class.cast(super.fromSection(in)));
        }

        public Builder info(String info) {
            return (Builder)((Object)Builder.class.cast(super.info(info)));
        }
    }
}

