/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.savvis.vpdc.domain.Link;
import org.jclouds.savvis.vpdc.domain.ResourceImpl;

public class Org
extends ResourceImpl {
    @Nullable
    private final String description;
    private final Set<Link> vDCs;
    private final Set<Link> images;

    public static Builder builder() {
        return new Builder();
    }

    public Org(String id, String name, String type, URI href, @Nullable String description, Set<Link> vDCs, Set<Link> images) {
        super(id, name, type, href);
        this.description = description;
        this.vDCs = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(vDCs, (Object)"vDCs")));
        this.images = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(images, (Object)"images")));
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<Link> getVDCs() {
        return this.vDCs;
    }

    public Set<Link> getImages() {
        return this.images;
    }

    @Override
    public Builder toBuilder() {
        return Builder.fromOrg(this);
    }

    @Override
    public String toString() {
        return "[id=" + this.id + ", href=" + this.href + ", name=" + this.name + ", type=" + this.type + ", description=" + this.description + ", vDCs=" + this.vDCs + ", images=" + this.images + "]";
    }

    public static class Builder
    extends ResourceImpl.Builder {
        private String description;
        private Set<Link> vDCs = Sets.newLinkedHashSet();
        private Set<Link> images = Sets.newLinkedHashSet();

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder vDC(Link vDC) {
            this.vDCs.add((Link)Preconditions.checkNotNull((Object)vDC, (Object)"vDC"));
            return this;
        }

        public Builder vDCs(Set<Link> vDCs) {
            this.vDCs.addAll((Collection)Preconditions.checkNotNull(vDCs, (Object)"vDCs"));
            return this;
        }

        public Builder image(Link image) {
            this.images.add((Link)Preconditions.checkNotNull((Object)image, (Object)"image"));
            return this;
        }

        public Builder images(Set<Link> images) {
            this.images.addAll((Collection)Preconditions.checkNotNull(images, (Object)"images"));
            return this;
        }

        @Override
        public Org build() {
            return new Org(this.id, this.name, this.type, this.href, this.description, this.vDCs, this.images);
        }

        public static Builder fromOrg(Org in) {
            return new Builder().id(in.getId()).name(in.getName()).type(in.getType()).href(in.getHref()).description(in.getDescription()).images(in.getImages()).vDCs(in.getVDCs());
        }

        @Override
        public Builder id(String id) {
            return (Builder)Builder.class.cast(super.id(id));
        }

        @Override
        public Builder name(String name) {
            return (Builder)Builder.class.cast(super.name(name));
        }

        @Override
        public Builder type(String type) {
            return (Builder)Builder.class.cast(super.type(type));
        }

        @Override
        public Builder href(URI href) {
            return (Builder)Builder.class.cast(super.href(href));
        }
    }
}

