/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.domain;

import org.jclouds.javax.annotation.Nullable;

public class TaskError {
    private final String message;
    private final int majorErrorCode;
    private final int minorErrorCode;
    private final String vendorSpecificErrorCode;

    public static Builder builder() {
        return new Builder();
    }

    public TaskError(String message, int majorErrorCode, int minorErrorCode, @Nullable String vendorSpecificErrorCode) {
        this.message = message;
        this.majorErrorCode = majorErrorCode;
        this.minorErrorCode = minorErrorCode;
        this.vendorSpecificErrorCode = vendorSpecificErrorCode;
    }

    public String getMessage() {
        return this.message;
    }

    public int getMajorErrorCode() {
        return this.majorErrorCode;
    }

    public int getMinorErrorCode() {
        return this.minorErrorCode;
    }

    @Nullable
    public String getVendorSpecificErrorCode() {
        return this.vendorSpecificErrorCode;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.majorErrorCode;
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + this.minorErrorCode;
        result = 31 * result + (this.vendorSpecificErrorCode == null ? 0 : this.vendorSpecificErrorCode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskError other = (TaskError)obj;
        if (this.majorErrorCode != other.majorErrorCode) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.minorErrorCode != other.minorErrorCode) {
            return false;
        }
        return !(this.vendorSpecificErrorCode == null ? other.vendorSpecificErrorCode != null : !this.vendorSpecificErrorCode.equals(other.vendorSpecificErrorCode));
    }

    public String toString() {
        return "[message=" + this.message + ", majorErrorCode=" + this.majorErrorCode + ", minorErrorCode=" + this.minorErrorCode + ", vendorSpecificErrorCode=" + this.vendorSpecificErrorCode + "]";
    }

    public static class Builder {
        private String message;
        private int majorErrorCode = -1;
        private int minorErrorCode = -1;
        private String vendorSpecificErrorCode;

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder majorErrorCode(int majorErrorCode) {
            this.majorErrorCode = majorErrorCode;
            return this;
        }

        public Builder minorErrorCode(int minorErrorCode) {
            this.minorErrorCode = minorErrorCode;
            return this;
        }

        public Builder vendorSpecificErrorCode(String vendorSpecificErrorCode) {
            this.vendorSpecificErrorCode = vendorSpecificErrorCode;
            return this;
        }

        public TaskError build() {
            return new TaskError(this.message, this.majorErrorCode, this.minorErrorCode, this.vendorSpecificErrorCode);
        }
    }
}

