/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.savvis.vpdc.domain.FirewallService;
import org.jclouds.savvis.vpdc.domain.Network;
import org.jclouds.savvis.vpdc.domain.Org;
import org.jclouds.savvis.vpdc.domain.Task;
import org.jclouds.savvis.vpdc.domain.VDC;
import org.jclouds.savvis.vpdc.domain.VM;
import org.jclouds.savvis.vpdc.filters.SetVCloudTokenCookie;
import org.jclouds.savvis.vpdc.functions.DefaultOrgIfNull;
import org.jclouds.savvis.vpdc.options.GetVMOptions;
import org.jclouds.savvis.vpdc.xml.FirewallServiceHandler;
import org.jclouds.savvis.vpdc.xml.NetworkHandler;
import org.jclouds.savvis.vpdc.xml.OrgHandler;
import org.jclouds.savvis.vpdc.xml.TaskHandler;
import org.jclouds.savvis.vpdc.xml.VDCHandler;
import org.jclouds.savvis.vpdc.xml.VMHandler;

@RequestFilters(value={SetVCloudTokenCookie.class})
public interface BrowsingAsyncClient {
    @GET
    @XMLResponseParser(value=OrgHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Path(value="v{jclouds.api-version}/org/{billingSiteId}")
    public ListenableFuture<Org> getOrg(@PathParam(value="billingSiteId") @Nullable @ParamParser(value=DefaultOrgIfNull.class) String var1);

    @GET
    @XMLResponseParser(value=VDCHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Path(value="v{jclouds.api-version}/org/{billingSiteId}/vdc/{vpdcId}")
    public ListenableFuture<VDC> getVDCInOrg(@PathParam(value="billingSiteId") @Nullable @ParamParser(value=DefaultOrgIfNull.class) String var1, @PathParam(value="vpdcId") String var2);

    @GET
    @XMLResponseParser(value=NetworkHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Path(value="v{jclouds.api-version}/org/{billingSiteId}/vdc/{vpdcId}/network/{network-tier-name}")
    public ListenableFuture<Network> getNetworkInVDC(@PathParam(value="billingSiteId") @Nullable @ParamParser(value=DefaultOrgIfNull.class) String var1, @PathParam(value="vpdcId") String var2, @PathParam(value="network-tier-name") String var3);

    @GET
    @XMLResponseParser(value=VMHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Path(value="v{jclouds.api-version}/org/{billingSiteId}/vdc/{vpdcId}/vApp/{vAppId}")
    public ListenableFuture<VM> getVMInVDC(@PathParam(value="billingSiteId") @Nullable @ParamParser(value=DefaultOrgIfNull.class) String var1, @PathParam(value="vpdcId") String var2, @PathParam(value="vAppId") String var3, GetVMOptions ... var4);

    @GET
    @XMLResponseParser(value=VMHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<VM> getVM(@EndpointParam URI var1, GetVMOptions ... var2);

    @GET
    @XMLResponseParser(value=TaskHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Path(value="v{jclouds.api-version}/task/{taskId}")
    public ListenableFuture<Task> getTask(@PathParam(value="taskId") String var1);

    @GET
    @XMLResponseParser(value=FirewallServiceHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Path(value="v{jclouds.api-version}/org/{billingSiteId}/vdc/{vpdcId}/FirewallService")
    public ListenableFuture<FirewallService> listFirewallRules(@PathParam(value="billingSiteId") @Nullable @ParamParser(value=DefaultOrgIfNull.class) String var1, @PathParam(value="vpdcId") String var2);
}

