/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.savvis.vpdc.VPDCClient;
import org.jclouds.savvis.vpdc.domain.Task;

@Singleton
public class TaskSuccess
implements Predicate<String> {
    private final VPDCClient client;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public TaskSuccess(VPDCClient client) {
        this.client = client;
    }

    public boolean apply(String taskId) {
        this.logger.trace("looking for status on task %s", new Object[]{Preconditions.checkNotNull((Object)taskId, (Object)"taskId")});
        Task task = this.refresh(taskId);
        if (task == null) {
            return false;
        }
        this.logger.trace("%s: looking for task status %s: currently: %s", new Object[]{task.getId(), Task.Status.SUCCESS, task.getStatus()});
        if (task.getError() != null) {
            throw new IllegalStateException(String.format("task %s failed with exception %s", task.getId(), task.getError().toString()));
        }
        return task.getStatus() == Task.Status.SUCCESS;
    }

    private Task refresh(String taskId) {
        return this.client.getBrowsingClient().getTask(taskId);
    }
}

