/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.jclouds.savvis.vpdc.domain.Link;
import org.jclouds.savvis.vpdc.domain.NetworkConfigSection;
import org.jclouds.savvis.vpdc.domain.NetworkConnectionSection;
import org.jclouds.savvis.vpdc.domain.Resource;
import org.jclouds.savvis.vpdc.domain.ResourceImpl;
import org.jclouds.savvis.vpdc.domain.VM;
import org.xml.sax.Attributes;

public class Utils {
    public static Resource newResource(Map<String, String> attributes, String defaultType) {
        String uri = attributes.get("href");
        String type = attributes.get("type");
        String id = null;
        URI href = null;
        if (uri != null) {
            href = URI.create(uri);
            id = uri.substring(uri.lastIndexOf(47) + 1);
        }
        return attributes.containsKey("rel") ? new Link(id, attributes.get("name"), type != null ? type : defaultType, href, attributes.get("rel")) : new ResourceImpl(id, attributes.get("name"), type != null ? type : defaultType, href);
    }

    public static Set<String> getIpsFromVM(VM vm) {
        Iterable ipFromConnections = Iterables.transform(vm.getNetworkConnectionSections(), (Function)new Function<NetworkConnectionSection, String>(){

            public String apply(NetworkConnectionSection input) {
                return input.getIpAddress();
            }
        });
        Iterable ipsFromNat = Iterables.concat((Iterable)Iterables.transform(vm.getNetworkConfigSections(), (Function)new Function<NetworkConfigSection, Iterable<String>>(){

            public Iterable<String> apply(NetworkConfigSection input) {
                return Iterables.concat(input.getInternalToExternalNATRules().keySet(), input.getInternalToExternalNATRules().values());
            }
        }));
        return ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)ipFromConnections, (Iterable)ipsFromNat), (Predicate)Predicates.notNull()));
    }

    public static Map<String, String> cleanseAttributes(Attributes in) {
        ImmutableMap.Builder attrs = ImmutableMap.builder();
        for (int i = 0; i < in.getLength(); ++i) {
            String name = in.getQName(i);
            if (name.indexOf(58) != -1) {
                name = name.substring(name.indexOf(58) + 1);
            }
            attrs.put((Object)name, (Object)in.getValue(i));
        }
        return attrs.build();
    }

    public static String currentOrNull(StringBuilder currentText) {
        String returnVal = currentText.toString().trim();
        return returnVal.equals("") ? null : returnVal;
    }

    public static Resource newResource(Map<String, String> attributes) {
        return Utils.newResource(attributes, null);
    }
}

