/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.xml;

import org.jclouds.http.functions.ParseSax;
import org.jclouds.savvis.vpdc.domain.FirewallRule;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FirewallRuleHandler
extends ParseSax.HandlerWithResult<FirewallRule> {
    protected StringBuilder currentText = new StringBuilder();
    private FirewallRule.Builder builder = FirewallRule.builder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FirewallRule getResult() {
        try {
            FirewallRule firewallRule = this.builder.build();
            return firewallRule;
        }
        finally {
            this.builder = FirewallRule.builder();
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        String current = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        if (current != null) {
            if (SaxUtils.equalsOrSuffix((String)qName, (String)"Type")) {
                this.builder.firewallType(current);
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"IsEnabled")) {
                this.builder.isEnabled(Boolean.parseBoolean(current));
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Source")) {
                this.builder.source(current);
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Destination")) {
                this.builder.destination(current);
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Port")) {
                this.builder.port(current);
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Policy")) {
                this.builder.policy(current);
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Description")) {
                this.builder.description(current);
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Log")) {
                this.builder.isLogged(Boolean.parseBoolean(current));
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Tcp")) {
                this.builder.protocol("Tcp");
            } else if (qName.contains("Udp") || qName.contains("udp")) {
                this.builder.protocol("Udp");
            } else if (qName.contains("Icmp") || qName.contains("icmp") || qName.contains("Ping") || qName.contains("ping")) {
                this.builder.protocol("Icmp-ping");
            }
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

