/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.xml;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jclouds.ovf.xml.SectionHandler;
import org.jclouds.savvis.vpdc.domain.NetworkConfigSection;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class NetworkConfigSectionHandler
extends SectionHandler<NetworkConfigSection, NetworkConfigSection.Builder> {
    @Inject
    public NetworkConfigSectionHandler(Provider<NetworkConfigSection.Builder> builderProvider) {
        super(builderProvider);
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        Map attributes = SaxUtils.cleanseAttributes((Attributes)attrs);
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"Section") && "vApp:NetworkConfigSectionType".equals(attributes.get("type"))) {
            ((NetworkConfigSection.Builder)this.builder).network((String)attributes.get("Network"));
            ((NetworkConfigSection.Builder)this.builder).netmask((String)attributes.get("Netmask"));
            ((NetworkConfigSection.Builder)this.builder).gateway((String)attributes.get("Gateway"));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"NatRule")) {
            ((NetworkConfigSection.Builder)this.builder).internalToExternalNATRule((String)attributes.get("internalIP"), (String)attributes.get("externalIP"));
        }
    }

    public void endElement(String uri, String localName, String qName) {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"FenceMode")) {
            ((NetworkConfigSection.Builder)this.builder).fenceMode(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Dhcp")) {
            ((NetworkConfigSection.Builder)this.builder).dhcp(new Boolean(SaxUtils.currentOrNull((StringBuilder)this.currentText)));
        }
        super.endElement(uri, localName, qName);
    }
}

