/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.xml;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jclouds.ovf.Network;
import org.jclouds.ovf.NetworkSection;
import org.jclouds.ovf.xml.SectionHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class NetworkSectionHandler
extends SectionHandler<NetworkSection, NetworkSection.Builder> {
    protected Network.Builder networkBuilder = Network.builder();

    @Inject
    public NetworkSectionHandler(Provider<NetworkSection.Builder> builderProvider) {
        super(builderProvider);
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        Map attributes = SaxUtils.cleanseAttributes((Attributes)attrs);
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"Network")) {
            this.networkBuilder.name((String)attributes.get("name"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endElement(String uri, String localName, String qName) {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"Info")) {
            ((NetworkSection.Builder)this.builder).info(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Description")) {
            this.networkBuilder.description(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Network")) {
            try {
                ((NetworkSection.Builder)this.builder).network(this.networkBuilder.build());
            }
            finally {
                this.networkBuilder = Network.builder();
            }
        }
        super.endElement(uri, localName, qName);
    }
}

