/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.xml;

import com.google.common.collect.ImmutableMap;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.savvis.vpdc.domain.Link;
import org.jclouds.savvis.vpdc.domain.Org;
import org.jclouds.savvis.vpdc.domain.Resource;
import org.jclouds.savvis.vpdc.util.Utils;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class OrgHandler
extends ParseSax.HandlerWithResult<Org> {
    protected StringBuilder currentText = new StringBuilder();
    protected Org.Builder builder = Org.builder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Org getResult() {
        try {
            Org org = this.builder.build();
            return org;
        }
        finally {
            this.builder = Org.builder();
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        ImmutableMap attributes = Utils.cleanseAttributes(attrs);
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"Org")) {
            if (!attributes.containsKey("href") && this.getRequest() != null) {
                attributes = ImmutableMap.builder().putAll(attributes).put((Object)"href", (Object)this.getRequest().getEndpoint().toASCIIString()).build();
            }
            Resource org = Utils.newResource(attributes);
            this.builder.name(org.getName()).type(org.getType()).id(org.getId()).href(org.getHref());
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Link")) {
            Link link = (Link)Link.class.cast(Utils.newResource(attributes));
            if ("down".equals(link.getRel())) {
                this.builder.vDC(link);
            } else {
                this.builder.image(link);
            }
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"Description")) {
            this.builder.description(Utils.currentOrNull(this.currentText));
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

