/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.xml;

import java.util.Date;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.logging.Logger;
import org.jclouds.savvis.vpdc.domain.Resource;
import org.jclouds.savvis.vpdc.domain.Task;
import org.jclouds.savvis.vpdc.domain.TaskError;
import org.jclouds.savvis.vpdc.util.Utils;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TaskHandler
extends ParseSax.HandlerWithResult<Task> {
    @javax.annotation.Resource
    protected Logger logger = Logger.NULL;
    protected final DateService dateService;
    private Task.Builder builder = Task.builder();

    @Inject
    public TaskHandler(DateService dateService) {
        this.dateService = dateService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task getResult() {
        try {
            Task task = this.builder.build();
            return task;
        }
        finally {
            this.builder = Task.builder();
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Map<String, String> attributes = Utils.cleanseAttributes(attrs);
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"Task")) {
            Resource task = Utils.newResource(attributes);
            this.builder.id(task.getId());
            this.builder.type(task.getType());
            this.builder.href(task.getHref());
            if (attributes.containsKey("startTime")) {
                this.builder.startTime(this.parseDate(attributes.get("startTime")));
            }
            if (attributes.containsKey("endTime")) {
                this.builder.endTime(this.parseDate(attributes.get("endTime")));
            }
            this.builder.status(Task.Status.fromValue(attributes.get("status")));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Owner")) {
            this.builder.owner(Utils.newResource(attributes));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Result")) {
            this.builder.result(Utils.newResource(attributes));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Error")) {
            this.builder.error(new TaskError(attributes.get("message"), Integer.parseInt(attributes.get("majorErrorCode")), Integer.parseInt(attributes.get("minorErrorCode")), attributes.get("vendorSpecificErrorCode")));
        }
    }

    private Date parseDate(String toParse) {
        try {
            return this.dateService.iso8601DateParse(toParse);
        }
        catch (RuntimeException e) {
            this.logger.error((Throwable)e, "error parsing date, %s", new Object[]{toParse});
            return null;
        }
    }

    public void endElement(String uri, String localName, String qName) {
    }

    public void characters(char[] ch, int start, int length) {
    }
}

