/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.xml;

import com.google.common.collect.ImmutableMap;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jclouds.ovf.NetworkSection;
import org.jclouds.ovf.Section;
import org.jclouds.ovf.xml.NetworkSectionHandler;
import org.jclouds.ovf.xml.OperatingSystemSectionHandler;
import org.jclouds.ovf.xml.ProductSectionHandler;
import org.jclouds.ovf.xml.VirtualHardwareSectionHandler;
import org.jclouds.ovf.xml.internal.BaseVirtualSystemHandler;
import org.jclouds.savvis.vpdc.domain.NetworkConfigSection;
import org.jclouds.savvis.vpdc.domain.NetworkConnectionSection;
import org.jclouds.savvis.vpdc.domain.Resource;
import org.jclouds.savvis.vpdc.domain.VM;
import org.jclouds.savvis.vpdc.util.Utils;
import org.jclouds.savvis.vpdc.xml.NetworkConfigSectionHandler;
import org.jclouds.savvis.vpdc.xml.NetworkConnectionSectionHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class VMHandler
extends BaseVirtualSystemHandler<VM, VM.Builder> {
    @Inject
    public VMHandler(Provider<VM.Builder> builderProvider, OperatingSystemSectionHandler osHandler, VirtualHardwareSectionHandler hardwareHandler, ProductSectionHandler productHandler, Provider<NetworkSectionHandler> networkSectionHandler, Provider<NetworkConfigSectionHandler> networkConfigSectionHandler, Provider<NetworkConnectionSectionHandler> networkConnectionSectionHandler) {
        super(builderProvider, osHandler, hardwareHandler, productHandler);
        this.extensionHandlers = ImmutableMap.of((Object)"ovf:NetworkSection", networkSectionHandler, (Object)"vApp:NetworkConfigSectionType", networkConfigSectionHandler, (Object)"vApp:NetworkConnectionType", networkConnectionSectionHandler);
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        ImmutableMap attributes = Utils.cleanseAttributes(attrs);
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"VApp")) {
            if (!attributes.containsKey("href") && this.getRequest() != null) {
                attributes = ImmutableMap.builder().putAll(attributes).put((Object)"href", (Object)this.getRequest().getEndpoint().toASCIIString()).build();
            }
            Resource vApp = Utils.newResource(attributes);
            ((VM.Builder)this.builder).name(vApp.getName()).type(vApp.getType()).id(vApp.getId()).href(vApp.getHref());
            ((VM.Builder)this.builder).status(VM.Status.fromValue((String)attributes.get("status")));
        }
        super.startElement(uri, localName, qName, attrs);
    }

    protected void addAdditionalSection(String qName, Section additionalSection) {
        if (additionalSection instanceof NetworkSection) {
            ((VM.Builder)this.builder).networkSection((NetworkSection)NetworkSection.class.cast(additionalSection));
        } else if (additionalSection instanceof NetworkConfigSection) {
            ((VM.Builder)this.builder).networkConfigSection((NetworkConfigSection)((Object)NetworkConfigSection.class.cast(additionalSection)));
        } else if (additionalSection instanceof NetworkConnectionSection) {
            ((VM.Builder)this.builder).networkConnectionSection((NetworkConnectionSection)((Object)NetworkConnectionSection.class.cast(additionalSection)));
        } else {
            ((VM.Builder)this.builder).additionalSection(qName, additionalSection);
        }
    }
}

