/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.net.URISyntaxException;
import javax.jms.Queue;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.exchange.ExchangeDefaults;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.url.BindingURL;

public class AMQQueue
extends AMQDestination
implements Queue {
    public AMQQueue(String address) throws URISyntaxException {
        super(address);
    }

    public AMQQueue(BindingURL binding) {
        super(binding);
    }

    public AMQQueue(AMQShortString exchangeName, String name) {
        this(exchangeName, new AMQShortString(name));
    }

    public AMQQueue(AMQShortString exchangeName, AMQShortString name) {
        this(exchangeName, name, false);
    }

    public AMQQueue(AMQShortString exchangeName, AMQShortString routingKey, AMQShortString queueName) {
        super(exchangeName, ExchangeDefaults.DIRECT_EXCHANGE_CLASS, routingKey, false, false, queueName, false);
    }

    public AMQQueue(AMQShortString exchangeName, AMQShortString routingKey, AMQShortString queueName, AMQShortString[] bindingKeys) {
        super(exchangeName, ExchangeDefaults.DIRECT_EXCHANGE_CLASS, routingKey, false, false, queueName, false, bindingKeys);
    }

    public AMQQueue(String exchangeName, String name) {
        this(new AMQShortString(exchangeName), new AMQShortString(name), false);
    }

    public AMQQueue(AMQConnection connection, String name) {
        this(connection.getDefaultQueueExchangeName(), name);
    }

    public AMQQueue(AMQConnection connection, String name, boolean temporary) {
        this(connection.getDefaultQueueExchangeName(), new AMQShortString(name), temporary);
    }

    public AMQQueue(String exchangeName, String name, boolean temporary) {
        this(new AMQShortString(exchangeName), new AMQShortString(name), temporary);
    }

    public AMQQueue(AMQShortString exchangeName, AMQShortString name, boolean temporary) {
        this(exchangeName, name, temporary ? null : name, temporary, temporary, !temporary);
    }

    public AMQQueue(AMQShortString exchangeName, AMQShortString routingKey, AMQShortString queueName, boolean exclusive, boolean autoDelete) {
        this(exchangeName, routingKey, queueName, exclusive, autoDelete, false);
    }

    public AMQQueue(AMQShortString exchangeName, AMQShortString routingKey, AMQShortString queueName, boolean exclusive, boolean autoDelete, boolean durable) {
        this(exchangeName, routingKey, queueName, exclusive, autoDelete, durable, null);
    }

    public AMQQueue(AMQShortString exchangeName, AMQShortString routingKey, AMQShortString queueName, boolean exclusive, boolean autoDelete, boolean durable, AMQShortString[] bindingKeys) {
        super(exchangeName, ExchangeDefaults.DIRECT_EXCHANGE_CLASS, routingKey, exclusive, autoDelete, queueName, durable, bindingKeys);
    }

    public AMQShortString getRoutingKey() {
        if (this.getAMQQueueName() != null && this.getAMQQueueName().equals(super.getRoutingKey())) {
            return this.getAMQQueueName();
        }
        return super.getRoutingKey();
    }

    public boolean isNameRequired() {
        return this.getQueueName() == null;
    }
}

