/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.failover;

import java.util.concurrent.CountDownLatch;
import org.apache.qpid.AMQDisconnectedException;
import org.apache.qpid.client.failover.FailoverState;
import org.apache.qpid.client.protocol.AMQProtocolHandler;
import org.apache.qpid.client.state.AMQState;
import org.apache.qpid.client.state.AMQStateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverHandler
implements Runnable {
    private static final Logger _logger = LoggerFactory.getLogger(FailoverHandler.class);
    private AMQProtocolHandler _amqProtocolHandler;
    private String _host;
    private int _port;

    public FailoverHandler(AMQProtocolHandler amqProtocolHandler) {
        this._amqProtocolHandler = amqProtocolHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (Thread.currentThread().isDaemon()) {
            throw new IllegalStateException("FailoverHandler must run on a non-daemon thread.");
        }
        this._amqProtocolHandler.setFailoverLatch(new CountDownLatch(1));
        this._amqProtocolHandler.notifyFailoverStarting();
        Object object = this._amqProtocolHandler.getConnection().getFailoverMutex();
        synchronized (object) {
            this._amqProtocolHandler.failoverInProgress();
            AMQStateManager existingStateManager = this._amqProtocolHandler.getStateManager();
            this._amqProtocolHandler.setStateManager(new AMQStateManager());
            if (!this._amqProtocolHandler.getConnection().firePreFailover(this._host != null)) {
                _logger.info("Failover process veto-ed by client");
                this._amqProtocolHandler.setStateManager(existingStateManager);
                if (this._host != null) {
                    this._amqProtocolHandler.getConnection().exceptionReceived(new AMQDisconnectedException("Redirect was vetoed by client", null));
                } else {
                    this._amqProtocolHandler.getConnection().exceptionReceived(new AMQDisconnectedException("Failover was vetoed by client", null));
                }
                this._amqProtocolHandler.getFailoverLatch().countDown();
                this._amqProtocolHandler.setFailoverLatch(null);
                return;
            }
            _logger.info("Starting failover process");
            boolean failoverSucceeded = this._host != null ? this._amqProtocolHandler.getConnection().attemptReconnection(this._host, this._port) : this._amqProtocolHandler.getConnection().attemptReconnection();
            if (!failoverSucceeded) {
                this._amqProtocolHandler.setStateManager(existingStateManager);
                this._amqProtocolHandler.getConnection().exceptionReceived(new AMQDisconnectedException("Server closed connection and no failover was successful", null));
            } else {
                existingStateManager.setProtocolSession(this._amqProtocolHandler.getProtocolSession());
                if (existingStateManager.getCurrentState() != AMQState.CONNECTION_OPEN) {
                    existingStateManager.clearLastException();
                    existingStateManager.changeState(AMQState.CONNECTION_OPEN);
                }
                this._amqProtocolHandler.setStateManager(existingStateManager);
                try {
                    if (this._amqProtocolHandler.getConnection().firePreResubscribe()) {
                        _logger.info("Resubscribing on new connection");
                        this._amqProtocolHandler.getConnection().resubscribeSessions();
                    } else {
                        _logger.info("Client vetoed automatic resubscription");
                    }
                    this._amqProtocolHandler.getConnection().fireFailoverComplete();
                    this._amqProtocolHandler.setFailoverState(FailoverState.NOT_STARTED);
                    _logger.info("Connection failover completed successfully");
                }
                catch (Exception e) {
                    _logger.info("Failover process failed - exception being propagated by protocol handler");
                    this._amqProtocolHandler.setFailoverState(FailoverState.FAILED);
                    this._amqProtocolHandler.exception(e);
                }
            }
        }
        this._amqProtocolHandler.getFailoverLatch().countDown();
    }

    public void setHost(String host) {
        this._host = host;
    }

    public void setPort(int port) {
        this._port = port;
    }
}

