/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.handler;

import org.apache.qpid.AMQConnectionClosedException;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQSecurityException;
import org.apache.qpid.client.AMQAuthenticationException;
import org.apache.qpid.client.protocol.AMQProtocolSession;
import org.apache.qpid.client.state.StateAwareMethodListener;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ConnectionCloseBody;
import org.apache.qpid.framing.ConnectionCloseOkBody;
import org.apache.qpid.protocol.AMQConstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionCloseMethodHandler
implements StateAwareMethodListener<ConnectionCloseBody> {
    private static final Logger _logger = LoggerFactory.getLogger(ConnectionCloseMethodHandler.class);
    private static ConnectionCloseMethodHandler _handler = new ConnectionCloseMethodHandler();

    public static ConnectionCloseMethodHandler getInstance() {
        return _handler;
    }

    private ConnectionCloseMethodHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void methodReceived(AMQProtocolSession session, ConnectionCloseBody method, int channelId) throws AMQException {
        _logger.info("ConnectionClose frame received");
        AMQConstant errorCode = AMQConstant.getConstant(method.getReplyCode());
        AMQShortString reason = method.getReplyText();
        AMQException error = null;
        try {
            ConnectionCloseOkBody closeOkBody = session.getMethodRegistry().createConnectionCloseOkBody();
            session.writeFrame(closeOkBody.generateFrame(0));
            if (errorCode != AMQConstant.REPLY_SUCCESS) {
                if (errorCode == AMQConstant.NOT_ALLOWED) {
                    _logger.info("Error :" + errorCode + ":" + Thread.currentThread().getName());
                    error = new AMQAuthenticationException(errorCode, reason == null ? null : reason.toString(), null);
                } else if (errorCode == AMQConstant.ACCESS_REFUSED) {
                    _logger.info("Error :" + errorCode + ":" + Thread.currentThread().getName());
                    error = new AMQSecurityException(reason == null ? null : reason.toString(), null);
                } else {
                    _logger.info("Connection close received with error code " + errorCode);
                    error = new AMQConnectionClosedException(errorCode, "Error: " + reason, null);
                }
            }
        }
        finally {
            if (error != null) {
                session.notifyError(error);
            }
            session.closeProtocolSession();
        }
    }
}

