/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.transport;

import java.io.IOException;
import java.net.SocketAddress;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoHandler;
import org.apache.mina.transport.vmpipe.QpidVmPipeConnector;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.qpid.client.protocol.AMQProtocolHandler;
import org.apache.qpid.client.transport.ITransportConnection;
import org.apache.qpid.jms.BrokerDetails;
import org.apache.qpid.transport.network.mina.MINANetworkDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmPipeTransportConnection
implements ITransportConnection {
    private static final Logger _logger = LoggerFactory.getLogger(VmPipeTransportConnection.class);
    private int _port;
    private MINANetworkDriver _networkDriver;

    public VmPipeTransportConnection(int port) {
        this._port = port;
    }

    public void connect(AMQProtocolHandler protocolHandler, BrokerDetails brokerDetail) throws IOException {
        QpidVmPipeConnector ioConnector = new QpidVmPipeConnector();
        VmPipeAddress address = new VmPipeAddress(this._port);
        _logger.info("Attempting connection to " + address);
        this._networkDriver = new MINANetworkDriver((IoConnector)ioConnector, protocolHandler);
        protocolHandler.setNetworkDriver(this._networkDriver);
        ConnectFuture future = ioConnector.connect((SocketAddress)address, (IoHandler)this._networkDriver);
        future.join();
        future.getSession();
        this._networkDriver.setProtocolEngine(protocolHandler);
    }
}

