/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolVersion
implements Comparable {
    private final byte _majorVersion;
    private final byte _minorVersion;
    private final String _stringFormat;
    private static final SortedSet<ProtocolVersion> _supportedVersions;
    private static final Map<String, ProtocolVersion> _nameToVersionMap;
    private static final ProtocolVersion _defaultVersion;
    public static final ProtocolVersion v0_10;
    public static final ProtocolVersion v0_9;
    public static final ProtocolVersion v0_91;
    public static final ProtocolVersion v8_0;

    public ProtocolVersion(byte majorVersion, byte minorVersion) {
        this._majorVersion = majorVersion;
        this._minorVersion = minorVersion;
        this._stringFormat = this._majorVersion + "-" + this._minorVersion;
    }

    public byte getMajorVersion() {
        return this._majorVersion;
    }

    public byte getMinorVersion() {
        return this._minorVersion;
    }

    public byte getActualMinorVersion() {
        return this._minorVersion > 90 ? (byte)(this._minorVersion / 10) : this._minorVersion;
    }

    public byte getRevisionVersion() {
        return this._minorVersion > 90 ? (byte)(this._minorVersion % 10) : (byte)0;
    }

    public String toString() {
        return this._stringFormat;
    }

    public int compareTo(Object o) {
        ProtocolVersion pv = (ProtocolVersion)o;
        if (this._majorVersion == 8 && this._minorVersion == 0) {
            ProtocolVersion fixedThis = new ProtocolVersion(this._minorVersion, this._majorVersion);
            return fixedThis.compareTo(pv);
        }
        if (pv.getMajorVersion() == 8 && pv.getMinorVersion() == 0) {
            ProtocolVersion fixedOther = new ProtocolVersion(pv.getMinorVersion(), pv.getMajorVersion());
            return this.compareTo(fixedOther);
        }
        if (this._majorVersion > pv.getMajorVersion()) {
            return 1;
        }
        if (this._majorVersion < pv.getMajorVersion()) {
            return -1;
        }
        if (this._minorVersion > pv.getMinorVersion()) {
            return 1;
        }
        if (this.getMinorVersion() < pv.getMinorVersion()) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        return o != null && (o == this || this.compareTo(o) == 0);
    }

    public int hashCode() {
        return 0xFF & this._minorVersion | (0xFF & this._majorVersion) << 8;
    }

    public boolean isSupported() {
        return _supportedVersions.contains(this);
    }

    public static ProtocolVersion getLatestSupportedVersion() {
        return _supportedVersions.last();
    }

    public static SortedSet<ProtocolVersion> getSupportedProtocolVersions() {
        return _supportedVersions;
    }

    public static ProtocolVersion parse(String name) {
        return _nameToVersionMap.get(name);
    }

    public static ProtocolVersion defaultProtocolVersion() {
        return _defaultVersion;
    }

    static {
        _nameToVersionMap = new HashMap<String, ProtocolVersion>();
        v0_10 = new ProtocolVersion(0, 10);
        v0_9 = new ProtocolVersion(0, 9);
        v0_91 = new ProtocolVersion(0, 91);
        v8_0 = new ProtocolVersion(8, 0);
        TreeSet<ProtocolVersion> versions = new TreeSet<ProtocolVersion>();
        versions.add(v0_10);
        _nameToVersionMap.put("0-10", v0_10);
        versions.add(v0_9);
        _nameToVersionMap.put("0-9", v0_9);
        versions.add(v0_91);
        _nameToVersionMap.put("0-91", v0_91);
        versions.add(v8_0);
        _nameToVersionMap.put("8-0", v8_0);
        _supportedVersions = Collections.unmodifiableSortedSet(versions);
        ProtocolVersion systemDefinedVersion = _nameToVersionMap.get(System.getProperty("org.apache.qpid.amqp_version"));
        _defaultVersion = systemDefinedVersion == null ? ProtocolVersion.getLatestSupportedVersion() : systemDefinedVersion;
    }
}

