/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_0_91;

import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.BasicAckBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.amqp_0_91.AMQMethodBody_0_91;
import org.apache.qpid.framing.amqp_0_91.MethodDispatcher_0_91;

public class BasicAckBodyImpl
extends AMQMethodBody_0_91
implements BasicAckBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new BasicAckBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 60;
    public static final int METHOD_ID = 80;
    private final long _deliveryTag;
    private final byte _bitfield0;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public BasicAckBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._deliveryTag = this.readLong(buffer);
        this._bitfield0 = this.readBitfield(buffer);
    }

    public BasicAckBodyImpl(long deliveryTag, boolean multiple) {
        this._deliveryTag = deliveryTag;
        byte bitfield0 = 0;
        if (multiple) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        this._bitfield0 = bitfield0;
    }

    public int getClazz() {
        return 60;
    }

    public int getMethod() {
        return 80;
    }

    public final long getDeliveryTag() {
        return this._deliveryTag;
    }

    public final boolean getMultiple() {
        return (this._bitfield0 & 1) != 0;
    }

    protected int getBodySize() {
        int size = 9;
        return size;
    }

    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeLong(buffer, this._deliveryTag);
        this.writeBitfield(buffer, this._bitfield0);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_91)dispatcher).dispatchBasicAck(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[BasicAckBodyImpl: ");
        buf.append("deliveryTag=");
        buf.append(this.getDeliveryTag());
        buf.append(", ");
        buf.append("multiple=");
        buf.append(this.getMultiple());
        buf.append("]");
        return buf.toString();
    }
}

