/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.Struct;
import org.apache.qpid.transport.codec.Decoder;
import org.apache.qpid.transport.codec.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExchangeBoundResult
extends Struct {
    public static final int TYPE = 1794;
    private short packing_flags = 0;

    @Override
    public final int getStructType() {
        return 1794;
    }

    @Override
    public final int getSizeWidth() {
        return 4;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    public final boolean hasPayload() {
        return false;
    }

    public final byte getEncodedTrack() {
        return -1;
    }

    public final boolean isConnectionControl() {
        return false;
    }

    public ExchangeBoundResult() {
    }

    public ExchangeBoundResult(Option ... _options) {
        block8: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case EXCHANGE_NOT_FOUND: {
                    this.packing_flags = (short)(this.packing_flags | 0x100);
                    continue block8;
                }
                case QUEUE_NOT_FOUND: {
                    this.packing_flags = (short)(this.packing_flags | 0x200);
                    continue block8;
                }
                case QUEUE_NOT_MATCHED: {
                    this.packing_flags = (short)(this.packing_flags | 0x400);
                    continue block8;
                }
                case KEY_NOT_MATCHED: {
                    this.packing_flags = (short)(this.packing_flags | 0x800);
                    continue block8;
                }
                case ARGS_NOT_MATCHED: {
                    this.packing_flags = (short)(this.packing_flags | 0x1000);
                    continue block8;
                }
                case NONE: {
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + (Object)((Object)_options[i]));
                }
            }
        }
    }

    public final boolean hasExchangeNotFound() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final ExchangeBoundResult clearExchangeNotFound() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.dirty = true;
        return this;
    }

    public final boolean getExchangeNotFound() {
        return this.hasExchangeNotFound();
    }

    public final ExchangeBoundResult setExchangeNotFound(boolean value) {
        this.packing_flags = value ? (short)(this.packing_flags | 0x100) : (short)(this.packing_flags & 0xFFFFFEFF);
        this.dirty = true;
        return this;
    }

    public final ExchangeBoundResult exchangeNotFound(boolean value) {
        return this.setExchangeNotFound(value);
    }

    public final boolean hasQueueNotFound() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final ExchangeBoundResult clearQueueNotFound() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.dirty = true;
        return this;
    }

    public final boolean getQueueNotFound() {
        return this.hasQueueNotFound();
    }

    public final ExchangeBoundResult setQueueNotFound(boolean value) {
        this.packing_flags = value ? (short)(this.packing_flags | 0x200) : (short)(this.packing_flags & 0xFFFFFDFF);
        this.dirty = true;
        return this;
    }

    public final ExchangeBoundResult queueNotFound(boolean value) {
        return this.setQueueNotFound(value);
    }

    public final boolean hasQueueNotMatched() {
        return (this.packing_flags & 0x400) != 0;
    }

    public final ExchangeBoundResult clearQueueNotMatched() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFBFF);
        this.dirty = true;
        return this;
    }

    public final boolean getQueueNotMatched() {
        return this.hasQueueNotMatched();
    }

    public final ExchangeBoundResult setQueueNotMatched(boolean value) {
        this.packing_flags = value ? (short)(this.packing_flags | 0x400) : (short)(this.packing_flags & 0xFFFFFBFF);
        this.dirty = true;
        return this;
    }

    public final ExchangeBoundResult queueNotMatched(boolean value) {
        return this.setQueueNotMatched(value);
    }

    public final boolean hasKeyNotMatched() {
        return (this.packing_flags & 0x800) != 0;
    }

    public final ExchangeBoundResult clearKeyNotMatched() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFF7FF);
        this.dirty = true;
        return this;
    }

    public final boolean getKeyNotMatched() {
        return this.hasKeyNotMatched();
    }

    public final ExchangeBoundResult setKeyNotMatched(boolean value) {
        this.packing_flags = value ? (short)(this.packing_flags | 0x800) : (short)(this.packing_flags & 0xFFFFF7FF);
        this.dirty = true;
        return this;
    }

    public final ExchangeBoundResult keyNotMatched(boolean value) {
        return this.setKeyNotMatched(value);
    }

    public final boolean hasArgsNotMatched() {
        return (this.packing_flags & 0x1000) != 0;
    }

    public final ExchangeBoundResult clearArgsNotMatched() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFEFFF);
        this.dirty = true;
        return this;
    }

    public final boolean getArgsNotMatched() {
        return this.hasArgsNotMatched();
    }

    public final ExchangeBoundResult setArgsNotMatched(boolean value) {
        this.packing_flags = value ? (short)(this.packing_flags | 0x1000) : (short)(this.packing_flags & 0xFFFFEFFF);
        this.dirty = true;
        return this;
    }

    public final ExchangeBoundResult argsNotMatched(boolean value) {
        return this.setArgsNotMatched(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("exchangeNotFound", this.getExchangeNotFound());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("queueNotFound", this.getQueueNotFound());
        }
        if ((this.packing_flags & 0x400) != 0) {
            result.put("queueNotMatched", this.getQueueNotMatched());
        }
        if ((this.packing_flags & 0x800) != 0) {
            result.put("keyNotMatched", this.getKeyNotMatched());
        }
        if ((this.packing_flags & 0x1000) != 0) {
            result.put("argsNotMatched", this.getArgsNotMatched());
        }
        return result;
    }
}

