/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.nio.ByteBuffer;
import org.apache.qpid.transport.Header;
import org.apache.qpid.transport.MethodDelegate;
import org.apache.qpid.transport.ProtocolDelegate;
import org.apache.qpid.transport.ProtocolEvent;
import org.apache.qpid.transport.Struct;
import org.apache.qpid.transport.StructFactory;
import org.apache.qpid.transport.util.Functions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Method
extends Struct
implements ProtocolEvent {
    private int id;
    private int channel;
    private boolean idSet = false;
    private boolean sync = false;
    private boolean batch = false;
    private boolean unreliable = false;
    private CompletionListener completionListener;

    public static final Method create(int type) {
        return (Method)StructFactory.createInstruction(type);
    }

    public final int getId() {
        return this.id;
    }

    void setId(int id) {
        this.id = id;
        this.idSet = true;
    }

    boolean idSet() {
        return this.idSet;
    }

    @Override
    public final int getChannel() {
        return this.channel;
    }

    @Override
    public final void setChannel(int channel) {
        this.channel = channel;
    }

    public final boolean isSync() {
        return this.sync;
    }

    public final void setSync(boolean value) {
        this.sync = value;
    }

    public final boolean isBatch() {
        return this.batch;
    }

    final void setBatch(boolean value) {
        this.batch = value;
    }

    public final boolean isUnreliable() {
        return this.unreliable;
    }

    final void setUnreliable(boolean value) {
        this.unreliable = value;
    }

    public abstract boolean hasPayload();

    public Header getHeader() {
        return null;
    }

    public void setHeader(Header header) {
        throw new UnsupportedOperationException();
    }

    public ByteBuffer getBody() {
        return null;
    }

    public void setBody(ByteBuffer body) {
        throw new UnsupportedOperationException();
    }

    public int getBodySize() {
        ByteBuffer body = this.getBody();
        if (body == null) {
            return 0;
        }
        return body.remaining();
    }

    @Override
    public abstract byte getEncodedTrack();

    public abstract <C> void dispatch(C var1, MethodDelegate<C> var2);

    @Override
    public <C> void delegate(C context, ProtocolDelegate<C> delegate) {
        if (this.getEncodedTrack() == 3) {
            delegate.command(context, this);
        } else {
            delegate.control(context, this);
        }
    }

    public void setCompletionListener(CompletionListener completionListener) {
        this.completionListener = completionListener;
    }

    public void complete() {
        if (this.completionListener != null) {
            this.completionListener.onComplete(this);
            this.completionListener = null;
        }
    }

    public boolean hasCompletionListener() {
        return this.completionListener != null;
    }

    @Override
    public String toString() {
        ByteBuffer body;
        StringBuilder str = new StringBuilder();
        str.append("ch=");
        str.append(this.channel);
        if (this.getEncodedTrack() == 3 && this.idSet) {
            str.append(" id=");
            str.append(this.id);
        }
        if (this.sync || this.batch) {
            str.append(" ");
            str.append("[");
            if (this.sync) {
                str.append("S");
            }
            if (this.batch) {
                str.append("B");
            }
            str.append("]");
        }
        str.append(" ");
        str.append(super.toString());
        Header hdr = this.getHeader();
        if (hdr != null) {
            for (Struct st : hdr.getStructs()) {
                str.append("\n  ");
                str.append(st);
            }
        }
        if ((body = this.getBody()) != null) {
            str.append("\n  body=");
            str.append(Functions.str(body, 64));
        }
        return str.toString();
    }

    public static interface CompletionListener {
        public void onComplete(Method var1);
    }
}

