/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network;

import java.nio.ByteBuffer;
import org.apache.qpid.transport.Binding;
import org.apache.qpid.transport.Connection;
import org.apache.qpid.transport.ConnectionDelegate;
import org.apache.qpid.transport.Receiver;
import org.apache.qpid.transport.Sender;
import org.apache.qpid.transport.network.Assembler;
import org.apache.qpid.transport.network.Disassembler;
import org.apache.qpid.transport.network.InputHandler;
import org.apache.qpid.transport.network.security.sasl.SASLReceiver;
import org.apache.qpid.transport.network.security.sasl.SASLSender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConnectionBinding
implements Binding<Connection, ByteBuffer> {
    public static final int MAX_FRAME_SIZE = 65535;

    public static Binding<Connection, ByteBuffer> get(final Connection connection) {
        return new ConnectionBinding(){

            public Connection connection() {
                return connection;
            }
        };
    }

    public static Binding<Connection, ByteBuffer> get(final ConnectionDelegate delegate) {
        return new ConnectionBinding(){

            public Connection connection() {
                Connection conn = new Connection();
                conn.setConnectionDelegate(delegate);
                return conn;
            }
        };
    }

    public abstract Connection connection();

    @Override
    public Connection endpoint(Sender<ByteBuffer> sender) {
        Connection conn = this.connection();
        if (conn.getConnectionSettings() != null && conn.getConnectionSettings().isUseSASLEncryption()) {
            sender = new SASLSender(sender);
            conn.addConnectionListener(sender);
        }
        Disassembler dis = new Disassembler(sender, 65535);
        conn.setSender(dis);
        return conn;
    }

    @Override
    public Receiver<ByteBuffer> receiver(Connection conn) {
        if (conn.getConnectionSettings() != null && conn.getConnectionSettings().isUseSASLEncryption()) {
            SASLReceiver receiver = new SASLReceiver(new InputHandler(new Assembler(conn)));
            conn.addConnectionListener(receiver);
            return receiver;
        }
        return new InputHandler(new Assembler(conn));
    }
}

