/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network.mina;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferAllocator;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.ExecutorThreadModel;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.SimpleByteBufferAllocator;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.filter.ReadThrottleFilterBuilder;
import org.apache.mina.filter.SSLFilter;
import org.apache.mina.filter.WriteBufferLimitFilterBuilder;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.transport.socket.nio.MultiThreadSocketAcceptor;
import org.apache.mina.transport.socket.nio.MultiThreadSocketConnector;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import org.apache.mina.transport.socket.nio.SocketConnector;
import org.apache.mina.transport.socket.nio.SocketConnectorConfig;
import org.apache.mina.transport.socket.nio.SocketSessionConfig;
import org.apache.mina.util.NewThreadExecutor;
import org.apache.mina.util.SessionUtil;
import org.apache.qpid.protocol.ProtocolEngine;
import org.apache.qpid.protocol.ProtocolEngineFactory;
import org.apache.qpid.ssl.SSLContextFactory;
import org.apache.qpid.thread.QpidThreadExecutor;
import org.apache.qpid.transport.NetworkDriver;
import org.apache.qpid.transport.NetworkDriverConfiguration;
import org.apache.qpid.transport.OpenException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MINANetworkDriver
extends IoHandlerAdapter
implements NetworkDriver {
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    ProtocolEngine _protocolEngine;
    private boolean _useNIO = false;
    private int _processors = 4;
    private boolean _executorPool = false;
    private SSLContextFactory _sslFactory = null;
    private IoConnector _socketConnector;
    private IoAcceptor _acceptor;
    private IoSession _ioSession;
    private ProtocolEngineFactory _factory;
    private boolean _protectIO;
    private NetworkDriverConfiguration _config;
    private Throwable _lastException;
    private boolean _acceptingConnections = false;
    private WriteFuture _lastWriteFuture;
    private static final Logger _logger = LoggerFactory.getLogger(MINANetworkDriver.class);

    public MINANetworkDriver(boolean useNIO, int processors, boolean executorPool, boolean protectIO) {
        this._useNIO = useNIO;
        this._processors = processors;
        this._executorPool = executorPool;
        this._protectIO = protectIO;
    }

    public MINANetworkDriver(boolean useNIO, int processors, boolean executorPool, boolean protectIO, ProtocolEngine protocolEngine, IoSession session) {
        this._useNIO = useNIO;
        this._processors = processors;
        this._executorPool = executorPool;
        this._protectIO = protectIO;
        this._protocolEngine = protocolEngine;
        this._ioSession = session;
        this._ioSession.setAttachment((Object)this._protocolEngine);
    }

    public MINANetworkDriver() {
    }

    public MINANetworkDriver(IoConnector ioConnector) {
        this._socketConnector = ioConnector;
    }

    public MINANetworkDriver(IoConnector ioConnector, ProtocolEngine engine) {
        this._socketConnector = ioConnector;
        this._protocolEngine = engine;
    }

    public void bind(int port, InetAddress[] addresses, ProtocolEngineFactory factory, NetworkDriverConfiguration config, SSLContextFactory sslFactory) throws BindException {
        this._factory = factory;
        this._config = config;
        this._acceptor = this._useNIO ? new MultiThreadSocketAcceptor(this._processors, (Executor)new NewThreadExecutor()) : new SocketAcceptor(this._processors, (Executor)new NewThreadExecutor());
        SocketAcceptorConfig sconfig = (SocketAcceptorConfig)this._acceptor.getDefaultConfig();
        sconfig.setThreadModel((ThreadModel)ExecutorThreadModel.getInstance((String)"MINANetworkDriver(Acceptor)"));
        SocketSessionConfig sc = (SocketSessionConfig)sconfig.getSessionConfig();
        if (config != null) {
            sc.setReceiveBufferSize(config.getReceiveBufferSize().intValue());
            sc.setSendBufferSize(config.getSendBufferSize().intValue());
            sc.setTcpNoDelay(config.getTcpNoDelay().booleanValue());
        }
        if (sslFactory != null) {
            this._sslFactory = sslFactory;
        }
        if (addresses != null && addresses.length > 0) {
            for (InetAddress addr : addresses) {
                try {
                    this._acceptor.bind((SocketAddress)new InetSocketAddress(addr, port), (IoHandler)this, (IoServiceConfig)sconfig);
                }
                catch (IOException e) {
                    throw new BindException(String.format("Could not bind to %1s:%2s", addr, port));
                }
            }
        } else {
            try {
                this._acceptor.bind((SocketAddress)new InetSocketAddress(port), (IoHandler)this, (IoServiceConfig)sconfig);
            }
            catch (IOException e) {
                throw new BindException(String.format("Could not bind to *:%1s", port));
            }
        }
        this._acceptingConnections = true;
    }

    public SocketAddress getRemoteAddress() {
        return this._ioSession.getRemoteAddress();
    }

    public SocketAddress getLocalAddress() {
        return this._ioSession.getLocalAddress();
    }

    public void open(int port, InetAddress destination, ProtocolEngine engine, NetworkDriverConfiguration config, SSLContextFactory sslFactory) throws OpenException {
        StackTraceElement[] trace;
        if (sslFactory != null) {
            this._sslFactory = sslFactory;
        }
        this._socketConnector = this._useNIO ? new MultiThreadSocketConnector(1, (Executor)new QpidThreadExecutor()) : new SocketConnector(1, (Executor)new QpidThreadExecutor());
        SocketConnectorConfig cfg = (SocketConnectorConfig)this._socketConnector.getDefaultConfig();
        String s = "";
        for (StackTraceElement elt : trace = Thread.currentThread().getStackTrace()) {
            if (!elt.getClassName().contains("Test")) continue;
            s = elt.getClassName();
            break;
        }
        cfg.setThreadModel((ThreadModel)ExecutorThreadModel.getInstance((String)("MINANetworkDriver(Client)-" + s)));
        SocketSessionConfig scfg = (SocketSessionConfig)cfg.getSessionConfig();
        scfg.setTcpNoDelay(config != null ? config.getTcpNoDelay() : true);
        scfg.setSendBufferSize(config != null ? config.getSendBufferSize() : 32768);
        scfg.setReceiveBufferSize(config != null ? config.getReceiveBufferSize() : 32768);
        if (this._socketConnector instanceof SocketConnector) {
            ((SocketConnector)this._socketConnector).setWorkerTimeout(0);
        }
        ConnectFuture future = this._socketConnector.connect((SocketAddress)new InetSocketAddress(destination, port), (IoHandler)this, (IoServiceConfig)cfg);
        future.join();
        if (!future.isConnected()) {
            throw new OpenException("Could not open connection", this._lastException);
        }
        this._ioSession = future.getSession();
        this._ioSession.setAttachment((Object)engine);
        engine.setNetworkDriver(this);
        this._protocolEngine = engine;
    }

    public void setMaxReadIdle(int idleTime) {
        this._ioSession.setIdleTime(IdleStatus.READER_IDLE, idleTime);
    }

    public void setMaxWriteIdle(int idleTime) {
        this._ioSession.setIdleTime(IdleStatus.WRITER_IDLE, idleTime);
    }

    public void close() {
        if (this._lastWriteFuture != null) {
            this._lastWriteFuture.join();
        }
        if (this._acceptor != null) {
            this._acceptor.unbindAll();
        }
        if (this._ioSession != null) {
            this._ioSession.close();
        }
    }

    public void flush() {
        if (this._lastWriteFuture != null) {
            this._lastWriteFuture.join();
        }
    }

    public void send(java.nio.ByteBuffer msg) {
        ByteBuffer minaBuf = ByteBuffer.allocate((int)msg.capacity());
        minaBuf.put(msg);
        minaBuf.flip();
        this._lastWriteFuture = this._ioSession.write((Object)minaBuf);
    }

    public void setIdleTimeout(int i) {
    }

    public void exceptionCaught(IoSession protocolSession, Throwable throwable) throws Exception {
        if (this._protocolEngine != null) {
            this._protocolEngine.exception(throwable);
        } else {
            _logger.error("Exception thrown and no ProtocolEngine to handle it", throwable);
        }
        this._lastException = throwable;
    }

    public void messageReceived(IoSession protocolSession, Object message) throws Exception {
        if (!(message instanceof ByteBuffer)) {
            throw new IllegalStateException("Handed unhandled message. message.class = " + message.getClass() + " message = " + message);
        }
        ((ProtocolEngine)protocolSession.getAttachment()).received(((ByteBuffer)message).buf());
    }

    public void sessionClosed(IoSession protocolSession) throws Exception {
        ((ProtocolEngine)protocolSession.getAttachment()).closed();
    }

    public void sessionCreated(IoSession protocolSession) throws Exception {
        SessionUtil.initialize((IoSession)protocolSession);
        if (this._executorPool) {
            if (this._sslFactory != null) {
                protocolSession.getFilterChain().addAfter("AsynchronousReadFilter", "sslFilter", (IoFilter)new SSLFilter(this._sslFactory.buildServerContext()));
            }
        } else if (this._sslFactory != null) {
            protocolSession.getFilterChain().addBefore("protocolFilter", "sslFilter", (IoFilter)new SSLFilter(this._sslFactory.buildServerContext()));
        }
        if (this._protectIO) {
            IoFilterChain chain = protocolSession.getFilterChain();
            protocolSession.getFilterChain().addLast("tempExecutorFilterForFilterBuilder", (IoFilter)new ExecutorFilter());
            ReadThrottleFilterBuilder readfilter = new ReadThrottleFilterBuilder();
            readfilter.setMaximumConnectionBufferSize(this._config.getReceiveBufferSize().intValue());
            readfilter.attach(chain);
            WriteBufferLimitFilterBuilder writefilter = new WriteBufferLimitFilterBuilder();
            writefilter.setMaximumConnectionBufferSize((long)this._config.getSendBufferSize().intValue());
            writefilter.attach(chain);
            protocolSession.getFilterChain().remove("tempExecutorFilterForFilterBuilder");
        }
        if (this._ioSession == null) {
            this._ioSession = protocolSession;
        }
        if (this._acceptingConnections) {
            ProtocolEngine protocolEngine = this._factory.newProtocolEngine(this);
            MINANetworkDriver newDriver = new MINANetworkDriver(this._useNIO, this._processors, this._executorPool, this._protectIO, protocolEngine, protocolSession);
            protocolEngine.setNetworkDriver(newDriver);
        }
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        if (IdleStatus.WRITER_IDLE.equals(status)) {
            ((ProtocolEngine)session.getAttachment()).writerIdle();
        } else if (IdleStatus.READER_IDLE.equals(status)) {
            ((ProtocolEngine)session.getAttachment()).readerIdle();
        }
    }

    private ProtocolEngine getProtocolEngine() {
        return this._protocolEngine;
    }

    public void setProtocolEngineFactory(ProtocolEngineFactory engineFactory, boolean acceptingConnections) {
        this._factory = engineFactory;
        this._acceptingConnections = acceptingConnections;
    }

    public void setProtocolEngine(ProtocolEngine protocolEngine) {
        this._protocolEngine = protocolEngine;
        if (this._ioSession != null) {
            this._ioSession.setAttachment((Object)protocolEngine);
        }
    }

    static {
        ByteBuffer.setUseDirectBuffers((boolean)Boolean.getBoolean("amqj.enableDirectBuffers"));
        ByteBuffer.setAllocator((ByteBufferAllocator)new SimpleByteBufferAllocator());
    }
}

