/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.qpid.util.ConcurrentLinkedQueueAtomicSize;
import org.apache.qpid.util.MessageQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentLinkedMessageQueueAtomicSize<E>
extends ConcurrentLinkedQueueAtomicSize<E>
implements MessageQueue<E> {
    private static final Logger _logger = LoggerFactory.getLogger(ConcurrentLinkedMessageQueueAtomicSize.class);
    protected Queue<E> _messageHead = new ConcurrentLinkedQueueAtomicSize();
    protected AtomicInteger _messageHeadSize = new AtomicInteger(0);

    @Override
    public int size() {
        return super.size() + this._messageHeadSize.get();
    }

    public int headSize() {
        return this._messageHeadSize.get();
    }

    @Override
    public E poll() {
        if (this._messageHead.isEmpty()) {
            return super.poll();
        }
        E e = this._messageHead.poll();
        if (_logger.isDebugEnabled()) {
            _logger.debug("Providing item(" + e + ")from message head");
        }
        if (e != null) {
            this._messageHeadSize.decrementAndGet();
        }
        return e;
    }

    @Override
    public boolean remove(Object o) {
        if (this._messageHead.isEmpty()) {
            return super.remove(o);
        }
        if (this._messageHead.remove(o)) {
            this._messageHeadSize.decrementAndGet();
            return true;
        }
        return super.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this._messageHead.isEmpty()) {
            return super.removeAll(c);
        }
        throw new RuntimeException("Not implemented");
    }

    @Override
    public boolean isEmpty() {
        return this._messageHead.isEmpty() && super.isEmpty();
    }

    @Override
    public void clear() {
        super.clear();
        this._messageHead.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this._messageHead.contains(o) || super.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> o) {
        return this._messageHead.containsAll(o) || super.containsAll(o);
    }

    @Override
    public E element() {
        if (this._messageHead.isEmpty()) {
            return super.element();
        }
        return this._messageHead.element();
    }

    @Override
    public E peek() {
        if (this._messageHead.isEmpty()) {
            return super.peek();
        }
        E o = this._messageHead.peek();
        if (_logger.isDebugEnabled()) {
            _logger.debug("Peeking item (" + o + ") from message head");
        }
        return o;
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator mainMessageIterator = super.iterator();
        return new Iterator<E>(){
            final Iterator<E> _headIterator;
            final Iterator<E> _mainIterator;
            Iterator<E> last;
            {
                this._headIterator = ConcurrentLinkedMessageQueueAtomicSize.this._messageHead.iterator();
                this._mainIterator = mainMessageIterator;
            }

            @Override
            public boolean hasNext() {
                return this._headIterator.hasNext() || this._mainIterator.hasNext();
            }

            @Override
            public E next() {
                if (this._headIterator.hasNext()) {
                    this.last = this._headIterator;
                    return this._headIterator.next();
                }
                this.last = this._mainIterator;
                return this._mainIterator.next();
            }

            @Override
            public void remove() {
                this.last.remove();
                if (this.last == this._mainIterator) {
                    ConcurrentLinkedMessageQueueAtomicSize.this._size.decrementAndGet();
                } else {
                    ConcurrentLinkedMessageQueueAtomicSize.this._messageHeadSize.decrementAndGet();
                }
            }
        };
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public Object[] toArray() {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public boolean pushHead(E o) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Adding item(" + o + ") to head of queue");
        }
        if (this._messageHead.offer(o)) {
            this._messageHeadSize.incrementAndGet();
            return true;
        }
        return false;
    }
}

