/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.drools.model;

import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.servicemix.expression.JAXPBooleanXPathExpression;
import org.apache.servicemix.expression.JAXPStringXPathExpression;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Message {
    private static final SourceTransformer TRANFORMER = new SourceTransformer();
    private final NormalizedMessage message;
    private final NamespaceContext namespaceContext;

    public Message(NormalizedMessage message, NamespaceContext namespaceContext) {
        this.message = message;
        this.namespaceContext = namespaceContext;
        Source content = message.getContent();
        if (content != null) {
            try {
                content = new DOMSource(TRANFORMER.toDOMElement(content));
                message.setContent(content);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public NormalizedMessage getInternalMessage() {
        return this.message;
    }

    public boolean xpath(String xpath) throws Exception {
        JAXPBooleanXPathExpression expression = new JAXPBooleanXPathExpression(xpath);
        if (this.namespaceContext != null) {
            expression.setNamespaceContext(this.namespaceContext);
        }
        Boolean b = (Boolean)expression.evaluate(null, this.message);
        return b;
    }

    public String valueOf(String xpath) throws Exception {
        JAXPStringXPathExpression expression = new JAXPStringXPathExpression(xpath);
        if (this.namespaceContext != null) {
            expression.setNamespaceContext(this.namespaceContext);
        }
        return (String)expression.evaluate(null, this.message);
    }

    public Object getProperty(String name) {
        return this.message.getProperty(name);
    }

    public void setProperty(String name, Object value) {
        this.message.setProperty(name, value);
    }

    public Element getContent() {
        return (Element)((DOMSource)this.message.getContent()).getNode();
    }

    public Object getXPath(String path) throws XPathExpressionException {
        Element msgXML = this.getContent();
        if (msgXML != null) {
            XPath xpath = XPathFactory.newInstance().newXPath();
            Node value = (Node)xpath.evaluate(path, this.getContent(), XPathConstants.NODE);
            if (value == null || value.getNodeType() != 2) {
                throw new DOMException(8, "Attribute not found in message with XPath: " + path);
            }
            return value.getNodeValue();
        }
        return null;
    }

    public void setXPath(String path, Object value) throws XPathExpressionException {
        Element msgXML = this.getContent();
        if (msgXML != null) {
            XPath xpath = XPathFactory.newInstance().newXPath();
            Node node = (Node)xpath.evaluate(path, this.getContent(), XPathConstants.NODE);
            if (node == null || node.getNodeType() != 2) {
                throw new DOMException(8, "Attribute not found in message with xpath: " + path);
            }
            node.setNodeValue(value.toString());
        }
    }
}

