/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.web.deployer.tomcat;

import java.io.File;
import java.io.IOException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Service;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.ExpandWar;
import org.osgi.framework.Bundle;
import org.springframework.osgi.util.OsgiStringUtils;
import org.springframework.osgi.web.deployer.OsgiWarDeploymentException;
import org.springframework.osgi.web.deployer.WarDeployment;
import org.springframework.osgi.web.deployer.internal.util.Utils;
import org.springframework.osgi.web.deployer.support.AbstractWarDeployer;
import org.springframework.osgi.web.deployer.tomcat.OsgiCatalinaLoader;
import org.springframework.osgi.web.deployer.tomcat.TomcatContextUndeployer;
import org.springframework.osgi.web.deployer.tomcat.TomcatWarDeployment;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class TomcatWarDeployer
extends AbstractWarDeployer {
    private Service service;

    public void setService(Object service) {
        if (service != null) {
            Assert.isInstanceOf((Class)Service.class, (Object)service, (String)"Invalid Catalina Service given:");
            this.service = (Service)service;
        }
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.service == null) {
            this.log.info((Object)"No Catalina Service set; looking for one in the OSGi service registry...");
            try {
                this.service = (Service)Utils.createServerServiceProxy(this.getBundleContext(), Service.class, null);
                this.log.info((Object)("Found service " + this.service.getName()));
            }
            catch (RuntimeException ex) {
                this.log.error((Object)"No Catalina Service found, bailing out", (Throwable)ex);
                throw ex;
            }
        }
    }

    protected WarDeployment createDeployment(Bundle bundle, String contextPath) throws Exception {
        String docBase = this.createDocBase(bundle, contextPath);
        Context catalinaContext = this.createDefaultContext(contextPath, docBase);
        catalinaContext.setLoader(this.createCatalinaLoader(bundle));
        catalinaContext.setPrivileged(false);
        catalinaContext.setReloadable(false);
        TomcatWarDeployment deployment = new TomcatWarDeployment(new TomcatContextUndeployer(){

            public void undeploy(Context catalinaContext) throws OsgiWarDeploymentException {
                TomcatWarDeployer.this.stopCatalinaContext(catalinaContext);
            }
        }, bundle, catalinaContext);
        return deployment;
    }

    private Context createDefaultContext(String contextPath, String docBase) {
        StandardContext context = new StandardContext();
        context.setDocBase(docBase);
        context.setPath(contextPath);
        ContextConfig config = new ContextConfig();
        context.addLifecycleListener((LifecycleListener)config);
        return context;
    }

    protected void startDeployment(WarDeployment deployment) throws Exception {
        Assert.isInstanceOf((Class)TomcatWarDeployment.class, (Object)deployment, (String)"Wrong type of deployment used");
        this.startCatalinaContext(((TomcatWarDeployment)deployment).getCatalinaContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCatalinaContext(Context context) {
        Thread currentThread = Thread.currentThread();
        ClassLoader old = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(null);
            this.getHost().addChild((Container)context);
        }
        finally {
            currentThread.setContextClassLoader(old);
        }
    }

    private void stopCatalinaContext(Context catalinaContext) throws OsgiWarDeploymentException {
        String docBase = catalinaContext.getDocBase();
        String contextPath = catalinaContext.getPath();
        String messageEnding = "context [" + contextPath + "] from server " + this.getServerInfo();
        this.log.info((Object)("About to undeploy " + messageEnding));
        try {
            this.removeContext(catalinaContext);
            this.log.info((Object)("Context [" + contextPath + "] undeployed successfully from server " + this.getServerInfo()));
        }
        catch (Exception ex) {
            throw new OsgiWarDeploymentException("Cannot undeploy " + messageEnding, ex);
        }
        finally {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Cleaning unpacked folder " + docBase));
            }
            ExpandWar.delete((File)new File(docBase));
        }
    }

    private void removeContext(Context context) {
        context.getParent().removeChild((Container)context);
    }

    private Loader createCatalinaLoader(Bundle bundle) {
        OsgiCatalinaLoader loader = new OsgiCatalinaLoader();
        loader.setClassLoader(Utils.createWebAppClassLoader(bundle, StandardService.class));
        return loader;
    }

    private String createDocBase(Bundle bundle, String contextPath) throws IOException {
        File tmpFile = File.createTempFile("tomcat-" + contextPath.substring(1), ".osgi");
        tmpFile.delete();
        tmpFile.mkdir();
        String path = tmpFile.getCanonicalPath();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Unpacking bundle [" + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle) + "] to folder [" + path + "]..."));
        }
        Utils.unpackBundle(bundle, tmpFile);
        return path;
    }

    private Container getHost() {
        Container container = this.service.getContainer();
        if (container == null) {
            throw new IllegalStateException("The Tomcat server doesn't have any Engines defined");
        }
        Object[] children = container.findChildren();
        if (ObjectUtils.isEmpty((Object[])children)) {
            throw new IllegalStateException("The Tomcat server doesn't have any Hosts defined");
        }
        return children[0];
    }

    protected String getServerInfo() {
        return this.service.getInfo();
    }
}

