/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.paxlogging;

import java.util.Dictionary;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.paxlogging.PaxLoggingEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.ops4j.pax.logging.spi.PaxAppender;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class PaxLoggingConsumer
extends DefaultConsumer
implements PaxAppender {
    private static final transient Logger LOG = LoggerFactory.getLogger(PaxLoggingConsumer.class);
    private final PaxLoggingEndpoint endpoint;
    private ExecutorService executor;
    private ServiceRegistration registration;

    public PaxLoggingConsumer(PaxLoggingEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    public void doAppend(final PaxLoggingEvent paxLoggingEvent) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                PaxLoggingConsumer.this.sendExchange(paxLoggingEvent);
            }
        });
    }

    protected void sendExchange(PaxLoggingEvent paxLoggingEvent) {
        MDC.put((String)PaxLoggingConsumer.class.getName(), (String)this.endpoint.getName());
        if (paxLoggingEvent.getProperties().containsKey(PaxLoggingConsumer.class.getName())) {
            return;
        }
        Exchange exchange = this.endpoint.createExchange();
        exchange.getIn().setBody((Object)paxLoggingEvent);
        LOG.trace("PaxLogging {} is firing", (Object)this.endpoint.getName());
        try {
            this.getProcessor().process(exchange);
            if (exchange.getException() != null) {
                this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
            }
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        Properties props = new Properties();
        props.put("org.ops4j.pax.logging.appender.name", this.endpoint.getName());
        this.registration = this.endpoint.getComponent().getBundleContext().registerService(PaxAppender.class.getName(), (Object)this, (Dictionary)props);
        this.executor = Executors.newSingleThreadExecutor();
    }

    protected void doStop() throws Exception {
        if (this.registration != null) {
            this.registration.unregister();
        }
        this.executor.shutdown();
        super.doStop();
    }
}

