/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.bean;

import org.jsmpp.util.HexUtil;
import org.jsmpp.util.OctetUtil;

public class LongSMS {
    private static final int MAX_MESSAGE_7BIT = 160;
    private static final int MAX_MESSAGE_8BIT = 140;
    private static final int MAX_MESSAGE_SEGMENT_8BIT = 133;
    private static final int MAX_MESSAGE_SEGMENT_7BIT = 152;
    private static final byte UDHIE_IDENTIFIER_SAR = 8;
    private static final byte UDHIE_SAR_LENGTH = 4;
    private static int referenceNumber = 0;

    private static synchronized int getReferenceNumber() {
        if (++referenceNumber >= 65536) {
            referenceNumber = 0;
        }
        return referenceNumber;
    }

    private static byte[] copyShort2Bytes(int integer) {
        byte[] bytes = new byte[]{(byte)(integer >> 8 & 0xFF), (byte)(integer & 0xFF)};
        return bytes;
    }

    public static byte[][] splitMessage8Bit(byte[] aMessage) {
        int segmentNum = aMessage.length / 133;
        int messageLength = aMessage.length;
        if (segmentNum > 255) {
            segmentNum = 255;
            messageLength = segmentNum * 133;
        }
        if (messageLength % 133 > 0) {
            ++segmentNum;
        }
        byte[][] segments = new byte[segmentNum][];
        byte[] referenceNumber = LongSMS.copyShort2Bytes(LongSMS.getReferenceNumber());
        int i = 0;
        while (i < segmentNum) {
            System.out.println("i = " + i);
            int lengthOfData = segmentNum - i == 1 ? messageLength - i * 133 : 133;
            System.out.println("Length of data = " + lengthOfData);
            segments[i] = new byte[7 + lengthOfData];
            System.out.println("segments[" + i + "].length = " + segments[i].length);
            segments[i][0] = 6;
            segments[i][1] = 8;
            segments[i][2] = 4;
            System.arraycopy(referenceNumber, 0, segments[i], 3, 2);
            segments[i][5] = (byte)segmentNum;
            segments[i][6] = (byte)(i + 1);
            System.arraycopy(aMessage, i * 133, segments[i], 7, lengthOfData);
            ++i;
        }
        return segments;
    }

    private static byte[][] splitMessage7Bit(byte[] aMessage) {
        int segmentNum = aMessage.length / 152;
        int messageLength = aMessage.length;
        if (segmentNum > 255) {
            segmentNum = 255;
            messageLength = segmentNum * 152;
        }
        if (messageLength % 152 > 0) {
            ++segmentNum;
        }
        byte[][] segments = new byte[segmentNum][];
        byte[] tempBytes = new byte[152];
        byte[] referenceNumber = LongSMS.copyShort2Bytes(LongSMS.getReferenceNumber());
        int i = 0;
        while (i < segmentNum) {
            int lengthOfData = segmentNum - i == 1 ? messageLength - i * 152 : 152;
            System.arraycopy(aMessage, i * 152, tempBytes, 0, lengthOfData);
            byte[] data7Bit = LongSMS.encode7Bit(new String(tempBytes, 0, lengthOfData));
            segments[i] = new byte[7 + data7Bit.length];
            segments[i][0] = 6;
            segments[i][1] = 8;
            segments[i][2] = 4;
            System.arraycopy(referenceNumber, 0, segments[i], 3, 2);
            segments[i][5] = (byte)segmentNum;
            segments[i][6] = (byte)(i + 1);
            System.arraycopy(data7Bit, 0, segments[i], 7, data7Bit.length);
            ++i;
        }
        return segments;
    }

    private static byte[] encode7Bit(String aString) {
        int length = aString.length();
        char[] tempChars = new char[length + 1];
        byte[] tempBytes = new byte[length];
        aString.getChars(0, length, tempChars, 0);
        tempChars[length] = '\u0000';
        int i = 0;
        int j = 0;
        int power = 1;
        while (i < length) {
            if (power == 8) {
                if (++i >= length) break;
                power = 1;
            }
            tempBytes[j] = (byte)(tempChars[i] & (1 << 8 - power) - 1 | (tempChars[i + 1] & (1 << power) - 1) << 8 - power);
            tempChars[i + 1] = (char)(tempChars[i + 1] >> power);
            ++i;
            ++j;
            ++power;
        }
        byte[] bytes = new byte[j];
        System.arraycopy(tempBytes, 0, bytes, 0, j);
        return bytes;
    }

    private static byte[][] smsg(byte[] data) {
        return null;
    }

    public static void main(String[] args) {
        String hexMessage = "5465737420736D732067617465776179206C6F6E6720736D73732C205465737420736D732067617465776179206C6F6E6720736D73732C205465737420736D732067617465776179206C6F6E6720736D73732C205465737420736D732067617465776179206C6F6E6720736D73732C205465737420736D732067617465776179206C6F6E6720736D73732C205465737420736D732067617465776179206C6F6E6720736D73732C205465737420736D732067617465776179206C6F6E6720736D73732C205465737420736D732067617465776179206C6F6E6720736D73732C205465737420736D732067617465776179206C6F6E6720736D73732C205465737420736D732067617465776179206C6F6E6720736D73732020";
        String message = "Test sms gateway long smss, Test sms gateway long smss, Test sms gateway long smss, Test sms gateway long smss, Test sms gateway long smss, Test sms gateway long smss, Test sms gateway long smss, Test sms gateway long smss, Test sms gateway long smss, Test sms gatew";
        byte[][] splittedMsg = LongSMS.splitMessage8Bit(message.getBytes());
        int i = 0;
        while (i < splittedMsg.length) {
            System.out.println(splittedMsg[i].length);
            System.out.println(new String(splittedMsg[i]));
            System.out.println("sar_msg_refnum tag: " + HexUtil.convertBytesToHexString(splittedMsg[i], 0, 2));
            System.out.println("sar_msg_refnum length: " + OctetUtil.bytesToShort(splittedMsg[i], 2));
            System.out.println("sar_msg_refnum value: " + OctetUtil.bytesToShort(splittedMsg[i], 4));
            ++i;
        }
    }
}

