/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session.state;

import java.io.IOException;
import org.jsmpp.PDUStringException;
import org.jsmpp.bean.Bind;
import org.jsmpp.bean.Command;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.BaseResponseHandler;
import org.jsmpp.session.ServerResponseHandler;
import org.jsmpp.session.state.SMPPServerSessionState;
import org.jsmpp.util.DefaultDecomposer;
import org.jsmpp.util.PDUDecomposer;

class SMPPServerSessionOpen
implements SMPPServerSessionState {
    private static final PDUDecomposer pduDecomposer = new DefaultDecomposer();

    SMPPServerSessionOpen() {
    }

    public SessionState getSessionState() {
        return SessionState.OPEN;
    }

    public void processBind(Command pduHeader, byte[] pdu, ServerResponseHandler responseHandler) throws IOException {
        try {
            Bind bind = pduDecomposer.bind(pdu);
            responseHandler.processBind(bind);
        }
        catch (PDUStringException e) {
            responseHandler.sendNegativeResponse(pduHeader.getCommandId(), e.getErrorCode(), pduHeader.getSequenceNumber());
        }
        catch (IllegalArgumentException e) {
            responseHandler.sendNegativeResponse(pduHeader.getCommandId(), 3, pduHeader.getSequenceNumber());
        }
    }

    public void processDeliverSmResp(Command pduHeader, byte[] pdu, ServerResponseHandler responseHandler) throws IOException {
        throw new IOException("Invalid process for open session state");
    }

    public void processQuerySm(Command pduHeader, byte[] pdu, ServerResponseHandler responseHandler) throws IOException {
        throw new IOException("Invalid process for open session state");
    }

    public void processSubmitSm(Command pduHeader, byte[] pdu, ServerResponseHandler responseHandler) throws IOException {
        throw new IOException("Invalid process for open session state");
    }

    public void processSubmitMulti(Command pduHeader, byte[] pdu, ServerResponseHandler responseHandler) throws IOException {
        throw new IOException("Invalid process for open session state");
    }

    public void processEnquireLink(Command pduHeader, byte[] pdu, BaseResponseHandler sessionHandler) throws IOException {
        throw new IOException("Invalid process for open session state");
    }

    public void processEnquireLinkResp(Command pduHeader, byte[] pdu, BaseResponseHandler sessionHandler) throws IOException {
        throw new IOException("Invalid process for open session state");
    }

    public void processGenericNack(Command pduHeader, byte[] pdu, BaseResponseHandler responseHandler) throws IOException {
        throw new IOException("Invalid process for open session state");
    }

    public void processUnbind(Command pduHeader, byte[] pdu, BaseResponseHandler sessionHandler) throws IOException {
        throw new IOException("Invalid process for open session state");
    }

    public void processUnbindResp(Command pduHeader, byte[] pdu, BaseResponseHandler sessionHandler) throws IOException {
        throw new IOException("Invalid process for open session state");
    }

    public void processUnknownCid(Command pduHeader, byte[] pdu, BaseResponseHandler sessionHandler) throws IOException {
        throw new IOException("Invalid process for open session state");
    }

    public void processDataSm(Command pduHeader, byte[] pdu, BaseResponseHandler responseHandler) throws IOException {
        throw new IOException("Invalid process for open session state");
    }

    public void processDataSmResp(Command pduHeader, byte[] pdu, BaseResponseHandler responseHandler) throws IOException {
        throw new IOException("Invalid process for open session state");
    }

    public void processCancelSm(Command pduHeader, byte[] pdu, ServerResponseHandler responseHandler) throws IOException {
        throw new IOException("Invalid process for open session state");
    }

    public void processReplaceSm(Command pduHeader, byte[] pdu, ServerResponseHandler responseHandler) throws IOException {
        throw new IOException("Invalid process for open session state");
    }
}

