/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.util;

import org.jsmpp.PDUStringException;
import org.jsmpp.util.StringParameter;
import org.jsmpp.util.StringValidator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class OctetStringValidationTest {
    private static final String FULL_LENGTH_TEXT = "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor";
    private static final int MAX_SHORT_MESSAGE_LENGTH = 254;

    @Test
    public void zeroLength() throws Exception {
        String shortMessage = "";
        Assert.assertEquals((int)shortMessage.length(), (int)0);
        StringValidator.validateString(shortMessage.getBytes(), StringParameter.SHORT_MESSAGE);
    }

    @Test
    public void nonZeroBelow255Length() throws Exception {
        String shortMessage = "This is a simple message";
        Assert.assertTrue((shortMessage.length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((shortMessage.length() <= 254 ? 1 : 0) != 0);
        StringValidator.validateString(shortMessage.getBytes(), StringParameter.SHORT_MESSAGE);
    }

    @Test
    public void fullLegth() throws Exception {
        Assert.assertEquals((int)FULL_LENGTH_TEXT.length(), (int)254);
        StringValidator.validateString(FULL_LENGTH_TEXT.getBytes(), StringParameter.SHORT_MESSAGE);
    }

    @Test(expectedExceptions={PDUStringException.class})
    public void overLengthText() throws Exception {
        String shortMessage = "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor ";
        Assert.assertTrue((shortMessage.length() > 254 ? 1 : 0) != 0);
        StringValidator.validateString(shortMessage.getBytes(), StringParameter.SHORT_MESSAGE);
    }
}

