/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.util;

import org.jsmpp.util.OctetUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

public class OctetUtilTest {
    @Test
    public void intConversion() {
        int in = Integer.MIN_VALUE;
        byte[] bytes = OctetUtil.intToBytes(in);
        Assert.assertEquals((int)bytes.length, (int)4);
        int out = OctetUtil.bytesToInt(bytes);
        Assert.assertEquals((int)out, (int)in);
    }

    @Test
    public void shortConversion() {
        short in = Short.MIN_VALUE;
        byte[] bytes = OctetUtil.shortToBytes(in);
        Assert.assertEquals((int)bytes.length, (int)2);
        short out = OctetUtil.bytesToShort(bytes);
        Assert.assertEquals((short)out, (short)in);
    }

    @Test
    public void testAnotherShortConversion() {
        byte[] bytes = new byte[]{-10, 10};
        short shortVal = OctetUtil.bytesToShort(bytes);
        byte[] anotherByte = OctetUtil.shortToBytes(shortVal);
        Assert.assertEquals((byte[])anotherByte, (byte[])bytes);
        short anotherShortVal = OctetUtil.bytesToShort(anotherByte);
        Assert.assertEquals((short)anotherShortVal, (short)shortVal);
    }

    @Test
    public void testShortEncodeFromIgor() {
        Assert.assertEquals((int)468, (int)OctetUtil.bytesToShort(new byte[]{1, -44}, 0));
    }

    @Test
    public void testShortEncode() {
        short val = 468;
        byte[] bytes = OctetUtil.shortToBytes((short)468);
        short anotherVal = OctetUtil.bytesToShort(bytes);
        Assert.assertEquals((short)val, (short)anotherVal);
    }
}

