/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.blobstore;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.blobstore.AsyncBlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.internal.BaseBlobStore;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.strategy.internal.FetchBlobMetadata;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.http.options.GetOptions;
import org.jclouds.openstack.swift.CommonSwiftClient;
import org.jclouds.openstack.swift.blobstore.functions.BlobStoreListContainerOptionsToListContainerOptions;
import org.jclouds.openstack.swift.blobstore.functions.BlobToObject;
import org.jclouds.openstack.swift.blobstore.functions.ContainerToResourceList;
import org.jclouds.openstack.swift.blobstore.functions.ContainerToResourceMetadata;
import org.jclouds.openstack.swift.blobstore.functions.ObjectToBlob;
import org.jclouds.openstack.swift.blobstore.functions.ObjectToBlobMetadata;
import org.jclouds.openstack.swift.domain.ContainerMetadata;

@Singleton
public class SwiftBlobStore
extends BaseBlobStore {
    private final CommonSwiftClient sync;
    private final ContainerToResourceMetadata container2ResourceMd;
    private final BlobStoreListContainerOptionsToListContainerOptions container2ContainerListOptions;
    private final ContainerToResourceList container2ResourceList;
    private final ObjectToBlob object2Blob;
    private final BlobToObject blob2Object;
    private final ObjectToBlobMetadata object2BlobMd;
    private final BlobToHttpGetOptions blob2ObjectGetOptions;
    private final Provider<FetchBlobMetadata> fetchBlobMetadataProvider;

    @Inject
    protected SwiftBlobStore(BlobStoreContext context, BlobUtils blobUtils, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations, CommonSwiftClient sync, ContainerToResourceMetadata container2ResourceMd, BlobStoreListContainerOptionsToListContainerOptions container2ContainerListOptions, ContainerToResourceList container2ResourceList, ObjectToBlob object2Blob, BlobToObject blob2Object, ObjectToBlobMetadata object2BlobMd, BlobToHttpGetOptions blob2ObjectGetOptions, Provider<FetchBlobMetadata> fetchBlobMetadataProvider) {
        super(context, blobUtils, defaultLocation, locations);
        this.sync = sync;
        this.container2ResourceMd = container2ResourceMd;
        this.container2ContainerListOptions = container2ContainerListOptions;
        this.container2ResourceList = container2ResourceList;
        this.object2Blob = object2Blob;
        this.blob2Object = blob2Object;
        this.object2BlobMd = object2BlobMd;
        this.blob2ObjectGetOptions = blob2ObjectGetOptions;
        this.fetchBlobMetadataProvider = (Provider)Preconditions.checkNotNull(fetchBlobMetadataProvider, (Object)"fetchBlobMetadataProvider");
    }

    public PageSet<? extends StorageMetadata> list() {
        return new Function<Set<ContainerMetadata>, PageSet<? extends StorageMetadata>>(){

            public PageSet<? extends StorageMetadata> apply(Set<ContainerMetadata> from) {
                return new PageSetImpl(Iterables.transform(from, (Function)SwiftBlobStore.this.container2ResourceMd), null);
            }
        }.apply(this.sync.listContainers(new org.jclouds.openstack.swift.options.ListContainerOptions[0]));
    }

    public boolean containerExists(String container) {
        return this.sync.containerExists(container);
    }

    public boolean createContainerInLocation(Location location, String container) {
        return this.sync.createContainer(container);
    }

    public PageSet<? extends StorageMetadata> list(String container, ListContainerOptions options) {
        org.jclouds.openstack.swift.options.ListContainerOptions httpOptions = this.container2ContainerListOptions.apply(options);
        PageSet list = this.container2ResourceList.apply(this.sync.listObjects(container, httpOptions));
        return options.isDetailed() ? ((FetchBlobMetadata)this.fetchBlobMetadataProvider.get()).setContainerName(container).apply(list) : list;
    }

    public boolean blobExists(String container, String key) {
        return this.sync.objectExists(container, key);
    }

    public BlobMetadata blobMetadata(String container, String key) {
        return this.object2BlobMd.apply(this.sync.getObjectInfo(container, key));
    }

    public Blob getBlob(String container, String key, org.jclouds.blobstore.options.GetOptions optionsList) {
        GetOptions httpOptions = this.blob2ObjectGetOptions.apply(optionsList);
        return this.object2Blob.apply(this.sync.getObject(container, key, httpOptions));
    }

    public String putBlob(String container, Blob blob) {
        BlobStoreUtils.createParentIfNeededAsync((AsyncBlobStore)this.context.getAsyncBlobStore(), (String)container, (Blob)blob);
        return this.sync.putObject(container, this.blob2Object.apply(blob));
    }

    public String putBlob(String container, Blob blob, PutOptions options) {
        return this.putBlob(container, blob);
    }

    public void removeBlob(String container, String key) {
        this.sync.removeObject(container, key);
    }

    protected boolean deleteAndVerifyContainerGone(String container) {
        this.sync.deleteContainerIfEmpty(container);
        return !this.sync.containerExists(container);
    }

    public boolean createContainerInLocation(Location location, String container, CreateContainerOptions options) {
        if (options.isPublicRead()) {
            throw new UnsupportedOperationException("publicRead");
        }
        return this.createContainerInLocation(location, container);
    }
}

