/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.domain.internal;

import com.google.gson.annotations.SerializedName;
import java.net.URI;
import java.util.Arrays;
import java.util.Date;
import org.jclouds.openstack.swift.domain.ObjectInfo;

public class ObjectInfoImpl
implements ObjectInfo {
    private String name;
    private String container;
    private URI uri;
    private byte[] hash;
    private Long bytes;
    @SerializedName(value="content_type")
    private String contentType;
    @SerializedName(value="last_modified")
    private Date lastModified;

    public static Builder builder() {
        return new Builder();
    }

    public ObjectInfoImpl(String name, URI uri, String container, byte[] hash, Long bytes, String contentType, Date lastModified) {
        this.name = name;
        this.container = container;
        this.uri = uri;
        this.hash = hash;
        this.bytes = bytes;
        this.contentType = contentType;
        this.lastModified = lastModified;
    }

    ObjectInfoImpl() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getContainer() {
        return this.container;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public byte[] getHash() {
        return this.hash;
    }

    @Override
    public Long getBytes() {
        return this.bytes;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public Date getLastModified() {
        return this.lastModified;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.container == null ? 0 : this.container.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectInfoImpl other = (ObjectInfoImpl)obj;
        if (this.container == null ? other.container != null : !this.container.equals(other.container)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return String.format("[name=%s, container=%s, uri=%s, bytes=%s, contentType=%s, lastModified=%s, hash=%s]", this.name, this.container, this.uri, this.bytes, this.contentType, this.lastModified, Arrays.toString(this.hash));
    }

    public Builder toBuilder() {
        return ObjectInfoImpl.builder().fromObjectInfo(this);
    }

    @Override
    public int compareTo(ObjectInfo o) {
        return this.name.compareTo(o.getName());
    }

    public static class Builder {
        private String name;
        private String container;
        private URI uri;
        private byte[] hash;
        private Long bytes;
        private String contentType;
        private Date lastModified;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder container(String container) {
            this.container = container;
            return this;
        }

        public Builder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder hash(byte[] hash) {
            this.hash = hash;
            return this;
        }

        public Builder bytes(Long bytes) {
            this.bytes = bytes;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder lastModified(Date lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public ObjectInfoImpl build() {
            return new ObjectInfoImpl(this.name, this.uri, this.container, this.hash, this.bytes, this.contentType, this.lastModified);
        }

        public Builder fromObjectInfo(ObjectInfo in) {
            return this.name(in.getName()).container(in.getContainer()).uri(this.uri).hash(in.getHash()).bytes(in.getBytes()).contentType(in.getContentType()).lastModified(in.getLastModified());
        }
    }
}

