/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.logging.Logger;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.util.Strings2;

public class ParseSwiftErrorFromHttpResponse
implements HttpErrorHandler {
    @Resource
    protected Logger logger = Logger.NULL;
    public static final String PREFIX = "^/v[0-9][^/]*/[a-zA-Z]+_[^/]+/";
    public static final Pattern CONTAINER_PATH = Pattern.compile("^/v[0-9][^/]*/[a-zA-Z]+_[^/]+/([^/]+)$");
    public static final Pattern CONTAINER_KEY_PATH = Pattern.compile("^/v[0-9][^/]*/[a-zA-Z]+_[^/]+/([^/]+)/(.*)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleError(HttpCommand command, HttpResponse response) {
        HttpResponseException exception = new HttpResponseException(command, response);
        try {
            String content = this.parseErrorFromContentOrNull(command, response);
            exception = content != null ? new HttpResponseException(command, response, content) : exception;
            switch (response.getStatusCode()) {
                case 401: {
                    exception = new AuthorizationException(exception.getMessage(), (Throwable)exception);
                    return;
                }
                case 404: {
                    if (command.getCurrentRequest().getMethod().equals("DELETE")) return;
                    String path = command.getCurrentRequest().getEndpoint().getPath();
                    Matcher matcher = CONTAINER_PATH.matcher(path);
                    if (matcher.find()) {
                        exception = new ContainerNotFoundException(matcher.group(1), content);
                        return;
                    }
                    matcher = CONTAINER_KEY_PATH.matcher(path);
                    if (!matcher.find()) return;
                    exception = new KeyNotFoundException(matcher.group(1), matcher.group(2), content);
                    return;
                }
            }
            return;
        }
        finally {
            HttpUtils.releasePayload((HttpMessage)response);
            command.setException((Exception)exception);
        }
    }

    String parseErrorFromContentOrNull(HttpCommand command, HttpResponse response) {
        if (response.getPayload() != null) {
            try {
                return Strings2.toStringAndClose((InputStream)response.getPayload().getInput());
            }
            catch (IOException e) {
                this.logger.warn((Throwable)e, "exception reading error from response", new Object[]{response});
            }
        }
        return null;
    }
}

