/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.camel.BatchConsumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.component.aws.s3.S3Configuration;
import org.apache.camel.component.aws.s3.S3Endpoint;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.camel.spi.ShutdownAware;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3Consumer
extends ScheduledPollConsumer
implements BatchConsumer,
ShutdownAware {
    private static final transient Logger LOG = LoggerFactory.getLogger(S3Consumer.class);
    private volatile ShutdownRunningTask shutdownRunningTask;
    private volatile int pendingExchanges;

    public S3Consumer(S3Endpoint endpoint, Processor processor) throws NoFactoryAvailableException {
        super((Endpoint)endpoint, processor);
    }

    protected int poll() throws Exception {
        this.shutdownRunningTask = null;
        this.pendingExchanges = 0;
        String bucketName = this.getConfiguration().getBucketName();
        LOG.trace("Quering objects in bucket [{}]...", (Object)bucketName);
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest();
        listObjectsRequest.setBucketName(bucketName);
        listObjectsRequest.setMaxKeys(Integer.valueOf(this.getMaxMessagesPerPoll()));
        ObjectListing listObjects = this.getAmazonS3Client().listObjects(listObjectsRequest);
        LOG.trace("Found {} objects in bucket [{}]...", (Object)listObjects.getObjectSummaries().size(), (Object)bucketName);
        Queue<Exchange> exchanges = this.createExchanges(listObjects.getObjectSummaries());
        return this.processBatch(CastUtils.cast(exchanges));
    }

    protected Queue<Exchange> createExchanges(List<S3ObjectSummary> s3ObjectSummaries) {
        LOG.trace("Received {} messages in this poll", (Object)s3ObjectSummaries.size());
        LinkedList<Exchange> answer = new LinkedList<Exchange>();
        for (S3ObjectSummary s3ObjectSummary : s3ObjectSummaries) {
            S3Object s3Object = this.getAmazonS3Client().getObject(s3ObjectSummary.getBucketName(), s3ObjectSummary.getKey());
            Exchange exchange = this.getEndpoint().createExchange(s3Object);
            answer.add(exchange);
        }
        return answer;
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            exchange.setProperty("CamelBatchIndex", (Object)index);
            exchange.setProperty("CamelBatchSize", (Object)total);
            exchange.setProperty("CamelBatchComplete", (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            exchange.addOnCompletion(new Synchronization(){

                public void onComplete(Exchange exchange) {
                    S3Consumer.this.processCommit(exchange);
                }

                public void onFailure(Exchange exchange) {
                    S3Consumer.this.processRollback(exchange);
                }

                public String toString() {
                    return "S3ConsumerOnCompletion";
                }
            });
            LOG.trace("Processing exchange [{}]...", (Object)exchange);
            this.getProcessor().process(exchange);
        }
        return total;
    }

    protected void processCommit(Exchange exchange) {
        try {
            if (this.getConfiguration().isDeleteAfterRead()) {
                String bucketName = (String)exchange.getIn().getHeader("CamelAwsS3BucketName", String.class);
                String key = (String)exchange.getIn().getHeader("CamelAwsS3Key", String.class);
                LOG.trace("Deleting object from bucket {} with key {}...", (Object)bucketName, (Object)key);
                this.getAmazonS3Client().deleteObject(bucketName, key);
                LOG.trace("Object deleted");
            }
        }
        catch (AmazonClientException e) {
            LOG.warn("Error occurred during deleting object", (Throwable)e);
            exchange.setException((Throwable)e);
        }
    }

    protected void processRollback(Exchange exchange) {
        Exception cause = exchange.getException();
        if (cause != null) {
            LOG.warn("Exchange failed, so rolling back message status: " + exchange, (Throwable)cause);
        } else {
            LOG.warn("Exchange failed, so rolling back message status: {}", (Object)exchange);
        }
    }

    public boolean isBatchAllowed() {
        boolean answer = this.isRunAllowed();
        if (!answer) {
            return false;
        }
        if (this.shutdownRunningTask == null) {
            return true;
        }
        return ShutdownRunningTask.CompleteAllTasks == this.shutdownRunningTask;
    }

    public boolean deferShutdown(ShutdownRunningTask shutdownRunningTask) {
        this.shutdownRunningTask = shutdownRunningTask;
        return false;
    }

    public int getPendingExchangesSize() {
        int answer = ShutdownRunningTask.CompleteAllTasks == this.shutdownRunningTask ? this.pendingExchanges : 0;
        if (answer == 0 && this.isPolling()) {
            this.log.trace("Currently polling so returning 1 as pending exchanges");
            answer = 1;
        }
        return answer;
    }

    public void prepareShutdown(boolean forced) {
    }

    protected S3Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    protected AmazonS3Client getAmazonS3Client() {
        return this.getEndpoint().getS3Client();
    }

    public S3Endpoint getEndpoint() {
        return (S3Endpoint)super.getEndpoint();
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.getEndpoint().setMaxMessagesPerPoll(maxMessagesPerPoll);
    }

    public int getMaxMessagesPerPoll() {
        return this.getEndpoint().getMaxMessagesPerPoll();
    }

    public String toString() {
        return "S3Consumer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
    }
}

