/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sqs;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.camel.BatchConsumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.component.aws.sqs.SqsConfiguration;
import org.apache.camel.component.aws.sqs.SqsEndpoint;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.camel.spi.ShutdownAware;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqsConsumer
extends ScheduledPollConsumer
implements BatchConsumer,
ShutdownAware {
    private static final transient Logger LOG = LoggerFactory.getLogger(SqsConsumer.class);
    private volatile ShutdownRunningTask shutdownRunningTask;
    private volatile int pendingExchanges;

    public SqsConsumer(SqsEndpoint endpoint, Processor processor) throws NoFactoryAvailableException {
        super((Endpoint)endpoint, processor);
    }

    protected int poll() throws Exception {
        this.shutdownRunningTask = null;
        this.pendingExchanges = 0;
        ReceiveMessageRequest request = new ReceiveMessageRequest(this.getQueueUrl());
        request.setMaxNumberOfMessages(this.getMaxMessagesPerPoll() > 0 ? Integer.valueOf(this.getMaxMessagesPerPoll()) : null);
        request.setVisibilityTimeout(this.getConfiguration().getVisibilityTimeout() != null ? this.getConfiguration().getVisibilityTimeout() : null);
        request.setAttributeNames(this.getConfiguration().getAttributeNames() != null ? this.getConfiguration().getAttributeNames() : null);
        LOG.trace("Receiving messages with request [{}]...", (Object)request);
        ReceiveMessageResult messageResult = this.getClient().receiveMessage(request);
        LOG.trace("Received {} messages", (Object)messageResult.getMessages().size());
        Queue<Exchange> exchanges = this.createExchanges(messageResult.getMessages());
        return this.processBatch(CastUtils.cast(exchanges));
    }

    protected Queue<Exchange> createExchanges(List<Message> messages) {
        LOG.trace("Received {} messages in this poll", (Object)messages.size());
        LinkedList<Exchange> answer = new LinkedList<Exchange>();
        for (Message message : messages) {
            Exchange exchange = this.getEndpoint().createExchange(message);
            answer.add(exchange);
        }
        return answer;
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            exchange.setProperty("CamelBatchIndex", (Object)index);
            exchange.setProperty("CamelBatchSize", (Object)total);
            exchange.setProperty("CamelBatchComplete", (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            exchange.addOnCompletion(new Synchronization(){

                public void onComplete(Exchange exchange) {
                    SqsConsumer.this.processCommit(exchange);
                }

                public void onFailure(Exchange exchange) {
                    SqsConsumer.this.processRollback(exchange);
                }

                public String toString() {
                    return "SqsConsumerOnCompletion";
                }
            });
            LOG.trace("Processing exchange [{}]...", (Object)exchange);
            this.getProcessor().process(exchange);
        }
        return total;
    }

    protected void processCommit(Exchange exchange) {
        try {
            if (this.getConfiguration().isDeleteAfterRead().booleanValue()) {
                String receiptHandle = (String)exchange.getIn().getHeader("CamelAwsSqsReceiptHandle", String.class);
                DeleteMessageRequest deleteRequest = new DeleteMessageRequest(this.getQueueUrl(), receiptHandle);
                LOG.trace("Deleting message with receipt handle {}...", (Object)receiptHandle);
                this.getClient().deleteMessage(deleteRequest);
                LOG.trace("Message deleted");
            }
        }
        catch (AmazonClientException e) {
            LOG.warn("Error occurred during deleting message", (Throwable)e);
            exchange.setException((Throwable)e);
        }
    }

    protected void processRollback(Exchange exchange) {
        Exception cause = exchange.getException();
        if (cause != null) {
            LOG.warn("Exchange failed, so rolling back message status: " + exchange, (Throwable)cause);
        } else {
            LOG.warn("Exchange failed, so rolling back message status: {}", (Object)exchange);
        }
    }

    public boolean isBatchAllowed() {
        boolean answer = this.isRunAllowed();
        if (!answer) {
            return false;
        }
        if (this.shutdownRunningTask == null) {
            return true;
        }
        return ShutdownRunningTask.CompleteAllTasks == this.shutdownRunningTask;
    }

    public boolean deferShutdown(ShutdownRunningTask shutdownRunningTask) {
        this.shutdownRunningTask = shutdownRunningTask;
        return false;
    }

    public int getPendingExchangesSize() {
        int answer = ShutdownRunningTask.CompleteAllTasks == this.shutdownRunningTask ? this.pendingExchanges : 0;
        if (answer == 0 && this.isPolling()) {
            this.log.trace("Currently polling so returning 1 as pending exchanges");
            answer = 1;
        }
        return answer;
    }

    public void prepareShutdown(boolean forced) {
    }

    protected SqsConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    protected AmazonSQSClient getClient() {
        return this.getEndpoint().getClient();
    }

    protected String getQueueUrl() {
        return this.getEndpoint().getQueueUrl();
    }

    public SqsEndpoint getEndpoint() {
        return (SqsEndpoint)super.getEndpoint();
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.getEndpoint().setMaxMessagesPerPoll(maxMessagesPerPoll);
    }

    public int getMaxMessagesPerPoll() {
        return this.getEndpoint().getMaxMessagesPerPoll();
    }

    public String toString() {
        return "SqsConsumer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
    }
}

