/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.camel.component.netty.ChannelHandlerFactory;
import org.apache.camel.component.netty.ClientPipelineFactory;
import org.apache.camel.component.netty.NettyProducer;
import org.apache.camel.component.netty.handlers.ClientChannelHandler;
import org.apache.camel.component.netty.ssl.SSLEngineFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.ssl.SslHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClientPipelineFactory
extends ClientPipelineFactory {
    private static final transient Logger LOG = LoggerFactory.getLogger(DefaultClientPipelineFactory.class);
    private NettyProducer producer;

    public DefaultClientPipelineFactory(NettyProducer producer) {
        this.producer = producer;
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline channelPipeline = Channels.pipeline();
        SslHandler sslHandler = this.configureClientSSLOnDemand(this.producer);
        if (sslHandler != null) {
            LOG.debug("Client SSL handler configured and added to the ChannelPipeline");
            this.addToPipeline("ssl", channelPipeline, (ChannelHandler)sslHandler);
        }
        List<ChannelHandler> decoders = this.producer.getConfiguration().getDecoders();
        for (int x = 0; x < decoders.size(); ++x) {
            ChannelHandler decoder = decoders.get(x);
            if (decoder instanceof ChannelHandlerFactory) {
                decoder = ((ChannelHandlerFactory)decoder).newChannelHandler();
            }
            this.addToPipeline("decoder-" + x, channelPipeline, decoder);
        }
        List<ChannelHandler> encoders = this.producer.getConfiguration().getEncoders();
        for (int x = 0; x < encoders.size(); ++x) {
            ChannelHandler encoder = encoders.get(x);
            if (encoder instanceof ChannelHandlerFactory) {
                encoder = ((ChannelHandlerFactory)encoder).newChannelHandler();
            }
            this.addToPipeline("encoder-" + x, channelPipeline, encoder);
        }
        this.addToPipeline("handler", channelPipeline, (ChannelHandler)new ClientChannelHandler(this.producer));
        LOG.trace("Created ChannelPipeline: {}", (Object)channelPipeline);
        return channelPipeline;
    }

    private void addToPipeline(String name, ChannelPipeline pipeline, ChannelHandler handler) {
        pipeline.addLast(name, handler);
    }

    private SslHandler configureClientSSLOnDemand(NettyProducer producer) throws Exception {
        if (!producer.getConfiguration().isSsl()) {
            return null;
        }
        if (producer.getConfiguration().getSslHandler() != null) {
            return producer.getConfiguration().getSslHandler();
        }
        if (producer.getConfiguration().getSslContextParameters() != null) {
            SSLContext context = producer.getConfiguration().getSslContextParameters().createSSLContext();
            SSLEngine engine = context.createSSLEngine();
            engine.setUseClientMode(true);
            return new SslHandler(engine);
        }
        if (producer.getConfiguration().getKeyStoreFile() == null) {
            LOG.debug("keystorefile is null");
        }
        if (producer.getConfiguration().getTrustStoreFile() == null) {
            LOG.debug("truststorefile is null");
        }
        if (producer.getConfiguration().getPassphrase().toCharArray() == null) {
            LOG.debug("passphrase is null");
        }
        SSLEngineFactory sslEngineFactory = new SSLEngineFactory(producer.getConfiguration().getKeyStoreFormat(), producer.getConfiguration().getSecurityProvider(), producer.getConfiguration().getKeyStoreFile(), producer.getConfiguration().getTrustStoreFile(), producer.getConfiguration().getPassphrase().toCharArray());
        SSLEngine sslEngine = sslEngineFactory.createClientSSLEngine();
        return new SslHandler(sslEngine);
    }

    @Override
    public ClientPipelineFactory createPipelineFactory(NettyProducer producer) {
        return new DefaultClientPipelineFactory(producer);
    }
}

