/*
 * Decompiled with CFR 0.152.
 */
package javax.validation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.validation.Configuration;
import javax.validation.ValidationException;
import javax.validation.ValidationProviderResolver;
import javax.validation.ValidatorFactory;
import javax.validation.bootstrap.GenericBootstrap;
import javax.validation.bootstrap.ProviderSpecificBootstrap;
import javax.validation.spi.BootstrapState;
import javax.validation.spi.ValidationProvider;
import org.apache.servicemix.specs.locator.OsgiLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validation {
    public static ValidatorFactory buildDefaultValidatorFactory() {
        return Validation.byDefaultProvider().configure().buildValidatorFactory();
    }

    public static GenericBootstrap byDefaultProvider() {
        return new GenericBootstrapImpl();
    }

    public static <T extends Configuration<T>, U extends ValidationProvider<T>> ProviderSpecificBootstrap<T> byProvider(Class<U> providerType) {
        return new ProviderSpecificBootstrapImpl(providerType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetClassLoader
    implements PrivilegedAction<ClassLoader> {
        private final Class<?> clazz;

        public static ClassLoader fromContext() {
            GetClassLoader action = new GetClassLoader(null);
            if (System.getSecurityManager() != null) {
                return AccessController.doPrivileged(action);
            }
            return action.run();
        }

        public static ClassLoader fromClass(Class<?> clazz) {
            if (clazz == null) {
                throw new IllegalArgumentException("Class is null");
            }
            GetClassLoader action = new GetClassLoader(clazz);
            if (System.getSecurityManager() != null) {
                return AccessController.doPrivileged(action);
            }
            return action.run();
        }

        private GetClassLoader(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public ClassLoader run() {
            if (this.clazz != null) {
                return this.clazz.getClassLoader();
            }
            return Thread.currentThread().getContextClassLoader();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultValidationProviderResolver
    implements ValidationProviderResolver {
        private static final Map<ClassLoader, List<ValidationProvider<?>>> providersPerClassloader = new WeakHashMap();
        private static final String SERVICES_FILE = "META-INF/services/" + ValidationProvider.class.getName();

        private DefaultValidationProviderResolver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<ValidationProvider<?>> getValidationProviders() {
            List<ValidationProvider<?>> providers;
            ClassLoader classloader = GetClassLoader.fromContext();
            if (classloader == null) {
                classloader = GetClassLoader.fromClass(DefaultValidationProviderResolver.class);
            }
            Map<ClassLoader, List<ValidationProvider<?>>> map = providersPerClassloader;
            synchronized (map) {
                providers = providersPerClassloader.get(classloader);
            }
            if (providers == null) {
                providers = new ArrayList();
                try {
                    Class<ValidationProvider> providerClass = OsgiLocator.locate(ValidationProvider.class);
                    if (providerClass != null) {
                        providers.add(providerClass.newInstance());
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
                String name = null;
                try {
                    Enumeration<URL> providerDefinitions = classloader.getResources(SERVICES_FILE);
                    while (providerDefinitions.hasMoreElements()) {
                        URL url = providerDefinitions.nextElement();
                        InputStream stream = url.openStream();
                        try {
                            BufferedReader reader = new BufferedReader(new InputStreamReader(stream), 100);
                            name = reader.readLine();
                            while (name != null) {
                                if (!(name = name.trim()).startsWith("#")) {
                                    Class<?> providerClass = DefaultValidationProviderResolver.loadClass(name, DefaultValidationProviderResolver.class);
                                    providers.add((ValidationProvider)providerClass.newInstance());
                                }
                                name = reader.readLine();
                            }
                        }
                        finally {
                            stream.close();
                        }
                    }
                }
                catch (IOException e) {
                    throw new ValidationException("Unable to read " + SERVICES_FILE, e);
                }
                catch (ClassNotFoundException e) {
                    throw new ValidationException("Unable to load Bean Validation provider " + name, e);
                }
                catch (IllegalAccessException e) {
                    throw new ValidationException("Unable to instanciate Bean Validation provider" + name, e);
                }
                catch (InstantiationException e) {
                    throw new ValidationException("Unable to instanciate Bean Validation provider" + name, e);
                }
                Map<ClassLoader, List<ValidationProvider<?>>> map2 = providersPerClassloader;
                synchronized (map2) {
                    providersPerClassloader.put(classloader, providers);
                }
            }
            return providers;
        }

        private static Class<?> loadClass(String name, Class<?> caller) throws ClassNotFoundException {
            block3: {
                try {
                    ClassLoader loader = GetClassLoader.fromContext();
                    if (loader != null) {
                        return loader.loadClass(name);
                    }
                }
                catch (ClassNotFoundException e) {
                    if (caller != null) break block3;
                    throw e;
                }
            }
            return Class.forName(name, true, GetClassLoader.fromClass(caller));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GenericBootstrapImpl
    implements GenericBootstrap,
    BootstrapState {
        private ValidationProviderResolver resolver;
        private ValidationProviderResolver defaultResolver;

        private GenericBootstrapImpl() {
        }

        @Override
        public GenericBootstrap providerResolver(ValidationProviderResolver resolver) {
            this.resolver = resolver;
            return this;
        }

        @Override
        public ValidationProviderResolver getValidationProviderResolver() {
            return this.resolver;
        }

        @Override
        public ValidationProviderResolver getDefaultValidationProviderResolver() {
            if (this.defaultResolver == null) {
                this.defaultResolver = new DefaultValidationProviderResolver();
            }
            return this.defaultResolver;
        }

        @Override
        public Configuration<?> configure() {
            Configuration<?> config;
            List<ValidationProvider<?>> resolvers;
            ValidationProviderResolver resolver = this.resolver == null ? this.getDefaultValidationProviderResolver() : this.resolver;
            try {
                resolvers = resolver.getValidationProviders();
            }
            catch (RuntimeException re) {
                throw new ValidationException("Unable to get available provider resolvers.", re);
            }
            if (resolvers.size() == 0) {
                throw new ValidationException("Unable to find a default provider");
            }
            try {
                config = resolver.getValidationProviders().get(0).createGenericConfiguration(this);
            }
            catch (RuntimeException re) {
                throw new ValidationException("Unable to instantiate Configuration.", re);
            }
            return config;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProviderSpecificBootstrapImpl<T extends Configuration<T>, U extends ValidationProvider<T>>
    implements ProviderSpecificBootstrap<T> {
        private final Class<U> validationProviderClass;
        private ValidationProviderResolver resolver;

        public ProviderSpecificBootstrapImpl(Class<U> validationProviderClass) {
            this.validationProviderClass = validationProviderClass;
        }

        @Override
        public ProviderSpecificBootstrap<T> providerResolver(ValidationProviderResolver resolver) {
            this.resolver = resolver;
            return this;
        }

        @Override
        public T configure() {
            List<ValidationProvider<?>> resolvers;
            if (this.validationProviderClass == null) {
                throw new ValidationException("builder is mandatory. Use Validation.byDefaultProvider() to use the generic provider discovery mechanism");
            }
            GenericBootstrapImpl state = new GenericBootstrapImpl();
            if (this.resolver == null) {
                this.resolver = state.getDefaultValidationProviderResolver();
            } else {
                state.providerResolver(this.resolver);
            }
            try {
                resolvers = this.resolver.getValidationProviders();
            }
            catch (RuntimeException re) {
                throw new ValidationException("Unable to get available provider resolvers.", re);
            }
            for (ValidationProvider<?> provider : resolvers) {
                if (!this.validationProviderClass.isAssignableFrom(provider.getClass())) continue;
                ValidationProvider specificProvider = (ValidationProvider)this.validationProviderClass.cast(provider);
                return specificProvider.createSpecializedConfiguration(state);
            }
            throw new ValidationException("Unable to find provider: " + this.validationProviderClass);
        }
    }
}

