/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.aries.blueprint.ExtendedBeanMetadata;
import org.apache.aries.blueprint.ext.AbstractPropertyPlaceholder;
import org.apache.camel.component.properties.DefaultPropertiesParser;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.util.ObjectHelper;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.reflect.ComponentMetadata;

public class BlueprintPropertiesParser
extends DefaultPropertiesParser {
    private final BlueprintContainer container;
    private PropertiesParser delegate;
    private final Set<AbstractPropertyPlaceholder> placeholders = new LinkedHashSet<AbstractPropertyPlaceholder>();
    private Method method;

    public BlueprintPropertiesParser(BlueprintContainer container, PropertiesParser delegate) {
        this.container = container;
        this.delegate = delegate;
    }

    public String[] lookupPropertyPlaceholderIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (Object componentId : this.container.getComponentIds()) {
            Class clazz;
            String id = (String)componentId;
            ComponentMetadata meta = this.container.getComponentMetadata(id);
            if (!(meta instanceof ExtendedBeanMetadata) || (clazz = ((ExtendedBeanMetadata)meta).getRuntimeClass()) == null || !AbstractPropertyPlaceholder.class.isAssignableFrom(clazz)) continue;
            ids.add(id);
        }
        return ids.toArray(new String[ids.size()]);
    }

    public void addPropertyPlaceholder(String id) {
        Object component = this.container.getComponentInstance(id);
        if (component instanceof AbstractPropertyPlaceholder) {
            AbstractPropertyPlaceholder placeholder = (AbstractPropertyPlaceholder)component;
            this.placeholders.add(placeholder);
            this.log.debug("Adding Blueprint PropertyPlaceholder: {}", (Object)id);
            if (this.method == null) {
                try {
                    this.method = AbstractPropertyPlaceholder.class.getDeclaredMethod("getProperty", String.class);
                    this.method.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException("Cannot add blueprint property placeholder: " + id + " as the method getProperty is not accessible", e);
                }
            }
        }
    }

    public String parseProperty(String key, String value, Properties properties) {
        this.log.trace("Parsing property key: {} with value: {}", (Object)key, (Object)value);
        if (key != null) {
            for (AbstractPropertyPlaceholder placeholder : this.placeholders) {
                value = (String)ObjectHelper.invokeMethod((Method)this.method, (Object)placeholder, (Object[])new Object[]{key});
                if (value == null) continue;
                this.log.debug("Blueprint parsed property key: {} as value: {}", (Object)key, (Object)value);
                break;
            }
        }
        if (value == null && this.delegate != null) {
            value = this.delegate.parseProperty(key, value, properties);
        }
        this.log.trace("Returning parsed property key: {} as value: {}", (Object)key, (Object)value);
        return value;
    }
}

