/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management.mbeans.web.internal;

import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.karaf.management.mbeans.web.WebMBean;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class WebMBeanImpl
extends StandardMBean
implements WebMBean {
    private BundleContext bundleContext;

    public WebMBeanImpl() throws NotCompliantMBeanException {
        super(WebMBean.class);
    }

    public TabularData list() throws Exception {
        CompositeType webType = new CompositeType("Web Bundle", "An OSGi Web bundle", new String[]{"ID", "Name", "Context"}, new String[]{"ID of the bundle", "Name of the bundle", "Web Context"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING});
        TabularType tableType = new TabularType("Web Bundles", "Table of web bundles", webType, new String[]{"ID"});
        TabularDataSupport table = new TabularDataSupport(tableType);
        for (Bundle bundle : this.bundleContext.getBundles()) {
            String name;
            String webContext = (String)bundle.getHeaders().get("Web-ContextPath");
            if (webContext == null) {
                webContext = (String)bundle.getHeaders().get("Webapp-Context");
            }
            if (webContext == null) continue;
            webContext.trim();
            if (!webContext.startsWith("/")) {
                webContext = "/" + webContext;
            }
            name = (name = (String)bundle.getHeaders().get("Bundle-Name")) == null ? bundle.getSymbolicName() : name;
            name = name == null ? bundle.getLocation() : name;
            CompositeDataSupport data = new CompositeDataSupport(webType, new String[]{"ID", "Name", "Context"}, new Object[]{bundle.getBundleId(), name, webContext});
            table.put(data);
        }
        return table;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

