/*
 * Copyright 2008 University Corporation for Advanced Internet Development, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opensaml.ws.wsfed.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.opensaml.ws.wsfed.AppliesTo;
import org.opensaml.ws.wsfed.EndPointReference;
import org.opensaml.xml.AbstractXMLObject;
import org.opensaml.xml.XMLObject;

/** Implementation of the {@link AppliesTo} Object. */
public class AppliesToImpl extends AbstractXMLObject implements AppliesTo {

    /** Endpoint reference. */
    private EndPointReference endPointReference;

    /**
     * Constructor.
     * 
     * @param namespaceURI the namespace the element is in
     * @param elementLocalName the local name of the XML element this Object represents
     * @param namespacePrefix the prefix for the given namespace
     */
    protected AppliesToImpl(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    /** {@inheritDoc} */
    public EndPointReference getEndPointReference() {
        return endPointReference;
    }

    /** {@inheritDoc} */
    public void setEndPointReference(EndPointReference reference) {
        endPointReference = prepareForAssignment(endPointReference, reference);
    }

    /** {@inheritDoc} */
    public List<XMLObject> getOrderedChildren() {
        ArrayList<XMLObject> children = new ArrayList<XMLObject>();

        children.add(endPointReference);

        return Collections.unmodifiableList(children);
    }
}