/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.debug;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.debug.BlankDebugEventListener;
import org.antlr.runtime.debug.DebugParser;
import org.antlr.runtime.misc.Stats;

public class Profiler
extends BlankDebugEventListener {
    public static final String Version = "2";
    public static final String RUNTIME_STATS_FILENAME = "runtime.stats";
    public static final int NUM_RUNTIME_STATS = 29;
    public DebugParser parser = null;
    protected int ruleLevel = 0;
    protected int decisionLevel = 0;
    protected int maxLookaheadInCurrentDecision = 0;
    protected CommonToken lastTokenConsumed = null;
    protected List lookaheadStack = new ArrayList();
    public int numRuleInvocations = 0;
    public int numGuessingRuleInvocations = 0;
    public int maxRuleInvocationDepth = 0;
    public int numFixedDecisions = 0;
    public int numCyclicDecisions = 0;
    public int numBacktrackDecisions = 0;
    public int[] decisionMaxFixedLookaheads = new int[200];
    public int[] decisionMaxCyclicLookaheads = new int[200];
    public List decisionMaxSynPredLookaheads = new ArrayList();
    public int numHiddenTokens = 0;
    public int numCharsMatched = 0;
    public int numHiddenCharsMatched = 0;
    public int numSemanticPredicates = 0;
    public int numSyntacticPredicates = 0;
    protected int numberReportedErrors = 0;
    public int numMemoizationCacheMisses = 0;
    public int numMemoizationCacheHits = 0;
    public int numMemoizationCacheEntries = 0;

    public Profiler() {
    }

    public Profiler(DebugParser debugParser) {
        this.parser = debugParser;
    }

    public void enterRule(String string) {
        ++this.ruleLevel;
        ++this.numRuleInvocations;
        if (this.ruleLevel > this.maxRuleInvocationDepth) {
            this.maxRuleInvocationDepth = this.ruleLevel;
        }
    }

    public void examineRuleMemoization(IntStream intStream, int n, String string) {
        int n2 = this.parser.getRuleMemoization(n, intStream.index());
        if (n2 == -1) {
            ++this.numMemoizationCacheMisses;
            ++this.numGuessingRuleInvocations;
        } else {
            ++this.numMemoizationCacheHits;
        }
    }

    public void memoize(IntStream intStream, int n, int n2, String string) {
        ++this.numMemoizationCacheEntries;
    }

    public void exitRule(String string) {
        --this.ruleLevel;
    }

    public void enterDecision(int n) {
        ++this.decisionLevel;
        int n2 = this.parser.getTokenStream().index();
        this.lookaheadStack.add(new Integer(n2));
    }

    public void exitDecision(int n) {
        if (this.parser.isCyclicDecision) {
            ++this.numCyclicDecisions;
        } else {
            ++this.numFixedDecisions;
        }
        this.lookaheadStack.remove(this.lookaheadStack.size() - 1);
        --this.decisionLevel;
        if (this.parser.isCyclicDecision) {
            if (this.numCyclicDecisions >= this.decisionMaxCyclicLookaheads.length) {
                int[] nArray = new int[this.decisionMaxCyclicLookaheads.length * 2];
                System.arraycopy(this.decisionMaxCyclicLookaheads, 0, nArray, 0, this.decisionMaxCyclicLookaheads.length);
                this.decisionMaxCyclicLookaheads = nArray;
            }
            this.decisionMaxCyclicLookaheads[this.numCyclicDecisions - 1] = this.maxLookaheadInCurrentDecision;
        } else {
            if (this.numFixedDecisions >= this.decisionMaxFixedLookaheads.length) {
                int[] nArray = new int[this.decisionMaxFixedLookaheads.length * 2];
                System.arraycopy(this.decisionMaxFixedLookaheads, 0, nArray, 0, this.decisionMaxFixedLookaheads.length);
                this.decisionMaxFixedLookaheads = nArray;
            }
            this.decisionMaxFixedLookaheads[this.numFixedDecisions - 1] = this.maxLookaheadInCurrentDecision;
        }
        this.parser.isCyclicDecision = false;
        this.maxLookaheadInCurrentDecision = 0;
    }

    public void consumeToken(Token token) {
        this.lastTokenConsumed = (CommonToken)token;
    }

    public boolean inDecision() {
        return this.decisionLevel > 0;
    }

    public void consumeHiddenToken(Token token) {
        this.lastTokenConsumed = (CommonToken)token;
    }

    public void LT(int n, Token token) {
        if (this.inDecision()) {
            int n2 = this.lookaheadStack.size() - 1;
            Integer n3 = (Integer)this.lookaheadStack.get(n2);
            int n4 = this.parser.getTokenStream().index();
            int n5 = this.getNumberOfHiddenTokens(n3, n4);
            int n6 = n + n4 - n3 - n5;
            if (n6 > this.maxLookaheadInCurrentDecision) {
                this.maxLookaheadInCurrentDecision = n6;
            }
        }
    }

    public void beginBacktrack(int n) {
        ++this.numBacktrackDecisions;
    }

    public void endBacktrack(int n, boolean bl) {
        this.decisionMaxSynPredLookaheads.add(new Integer(this.maxLookaheadInCurrentDecision));
    }

    public void recognitionException(RecognitionException recognitionException) {
        ++this.numberReportedErrors;
    }

    public void semanticPredicate(boolean bl, String string) {
        if (this.inDecision()) {
            ++this.numSemanticPredicates;
        }
    }

    public void terminate() {
        String string = this.toNotifyString();
        try {
            Stats.writeReport(RUNTIME_STATS_FILENAME, string);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            iOException.printStackTrace(System.err);
        }
        System.out.println(Profiler.toString(string));
    }

    public void setParser(DebugParser debugParser) {
        this.parser = debugParser;
    }

    public String toNotifyString() {
        TokenStream tokenStream = this.parser.getTokenStream();
        for (int i = 0; i < tokenStream.size() && this.lastTokenConsumed != null && i <= this.lastTokenConsumed.getTokenIndex(); ++i) {
            Token token = tokenStream.get(i);
            if (token.getChannel() == 0) continue;
            ++this.numHiddenTokens;
            this.numHiddenCharsMatched += token.getText().length();
        }
        this.numCharsMatched = this.lastTokenConsumed.getStopIndex() + 1;
        this.decisionMaxFixedLookaheads = this.trim(this.decisionMaxFixedLookaheads, this.numFixedDecisions);
        this.decisionMaxCyclicLookaheads = this.trim(this.decisionMaxCyclicLookaheads, this.numCyclicDecisions);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Version);
        stringBuffer.append('\t');
        stringBuffer.append(this.parser.getClass().getName());
        stringBuffer.append('\t');
        stringBuffer.append(this.numRuleInvocations);
        stringBuffer.append('\t');
        stringBuffer.append(this.maxRuleInvocationDepth);
        stringBuffer.append('\t');
        stringBuffer.append(this.numFixedDecisions);
        stringBuffer.append('\t');
        stringBuffer.append(Stats.min(this.decisionMaxFixedLookaheads));
        stringBuffer.append('\t');
        stringBuffer.append(Stats.max(this.decisionMaxFixedLookaheads));
        stringBuffer.append('\t');
        stringBuffer.append(Stats.avg(this.decisionMaxFixedLookaheads));
        stringBuffer.append('\t');
        stringBuffer.append(Stats.stddev(this.decisionMaxFixedLookaheads));
        stringBuffer.append('\t');
        stringBuffer.append(this.numCyclicDecisions);
        stringBuffer.append('\t');
        stringBuffer.append(Stats.min(this.decisionMaxCyclicLookaheads));
        stringBuffer.append('\t');
        stringBuffer.append(Stats.max(this.decisionMaxCyclicLookaheads));
        stringBuffer.append('\t');
        stringBuffer.append(Stats.avg(this.decisionMaxCyclicLookaheads));
        stringBuffer.append('\t');
        stringBuffer.append(Stats.stddev(this.decisionMaxCyclicLookaheads));
        stringBuffer.append('\t');
        stringBuffer.append(this.numBacktrackDecisions);
        stringBuffer.append('\t');
        stringBuffer.append(Stats.min(this.toArray(this.decisionMaxSynPredLookaheads)));
        stringBuffer.append('\t');
        stringBuffer.append(Stats.max(this.toArray(this.decisionMaxSynPredLookaheads)));
        stringBuffer.append('\t');
        stringBuffer.append(Stats.avg(this.toArray(this.decisionMaxSynPredLookaheads)));
        stringBuffer.append('\t');
        stringBuffer.append(Stats.stddev(this.toArray(this.decisionMaxSynPredLookaheads)));
        stringBuffer.append('\t');
        stringBuffer.append(this.numSemanticPredicates);
        stringBuffer.append('\t');
        stringBuffer.append(this.parser.getTokenStream().size());
        stringBuffer.append('\t');
        stringBuffer.append(this.numHiddenTokens);
        stringBuffer.append('\t');
        stringBuffer.append(this.numCharsMatched);
        stringBuffer.append('\t');
        stringBuffer.append(this.numHiddenCharsMatched);
        stringBuffer.append('\t');
        stringBuffer.append(this.numberReportedErrors);
        stringBuffer.append('\t');
        stringBuffer.append(this.numMemoizationCacheHits);
        stringBuffer.append('\t');
        stringBuffer.append(this.numMemoizationCacheMisses);
        stringBuffer.append('\t');
        stringBuffer.append(this.numGuessingRuleInvocations);
        stringBuffer.append('\t');
        stringBuffer.append(this.numMemoizationCacheEntries);
        return stringBuffer.toString();
    }

    public String toString() {
        return Profiler.toString(this.toNotifyString());
    }

    protected static String[] decodeReportData(String string) {
        String[] stringArray = new String[29];
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        if (n != 29) {
            return null;
        }
        return stringArray;
    }

    public static String toString(String string) {
        String[] stringArray = Profiler.decodeReportData(string);
        if (stringArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ANTLR Runtime Report; Profile Version ");
        stringBuffer.append(stringArray[0]);
        stringBuffer.append('\n');
        stringBuffer.append("parser name ");
        stringBuffer.append(stringArray[1]);
        stringBuffer.append('\n');
        stringBuffer.append("Number of rule invocations ");
        stringBuffer.append(stringArray[2]);
        stringBuffer.append('\n');
        stringBuffer.append("Number of rule invocations in \"guessing\" mode ");
        stringBuffer.append(stringArray[27]);
        stringBuffer.append('\n');
        stringBuffer.append("max rule invocation nesting depth ");
        stringBuffer.append(stringArray[3]);
        stringBuffer.append('\n');
        stringBuffer.append("number of fixed lookahead decisions ");
        stringBuffer.append(stringArray[4]);
        stringBuffer.append('\n');
        stringBuffer.append("min lookahead used in a fixed lookahead decision ");
        stringBuffer.append(stringArray[5]);
        stringBuffer.append('\n');
        stringBuffer.append("max lookahead used in a fixed lookahead decision ");
        stringBuffer.append(stringArray[6]);
        stringBuffer.append('\n');
        stringBuffer.append("average lookahead depth used in fixed lookahead decisions ");
        stringBuffer.append(stringArray[7]);
        stringBuffer.append('\n');
        stringBuffer.append("standard deviation of depth used in fixed lookahead decisions ");
        stringBuffer.append(stringArray[8]);
        stringBuffer.append('\n');
        stringBuffer.append("number of arbitrary lookahead decisions ");
        stringBuffer.append(stringArray[9]);
        stringBuffer.append('\n');
        stringBuffer.append("min lookahead used in an arbitrary lookahead decision ");
        stringBuffer.append(stringArray[10]);
        stringBuffer.append('\n');
        stringBuffer.append("max lookahead used in an arbitrary lookahead decision ");
        stringBuffer.append(stringArray[11]);
        stringBuffer.append('\n');
        stringBuffer.append("average lookahead depth used in arbitrary lookahead decisions ");
        stringBuffer.append(stringArray[12]);
        stringBuffer.append('\n');
        stringBuffer.append("standard deviation of depth used in arbitrary lookahead decisions ");
        stringBuffer.append(stringArray[13]);
        stringBuffer.append('\n');
        stringBuffer.append("number of evaluated syntactic predicates ");
        stringBuffer.append(stringArray[14]);
        stringBuffer.append('\n');
        stringBuffer.append("min lookahead used in a syntactic predicate ");
        stringBuffer.append(stringArray[15]);
        stringBuffer.append('\n');
        stringBuffer.append("max lookahead used in a syntactic predicate ");
        stringBuffer.append(stringArray[16]);
        stringBuffer.append('\n');
        stringBuffer.append("average lookahead depth used in syntactic predicates ");
        stringBuffer.append(stringArray[17]);
        stringBuffer.append('\n');
        stringBuffer.append("standard deviation of depth used in syntactic predicates ");
        stringBuffer.append(stringArray[18]);
        stringBuffer.append('\n');
        stringBuffer.append("rule memoization cache size ");
        stringBuffer.append(stringArray[28]);
        stringBuffer.append('\n');
        stringBuffer.append("number of rule memoization cache hits ");
        stringBuffer.append(stringArray[25]);
        stringBuffer.append('\n');
        stringBuffer.append("number of rule memoization cache misses ");
        stringBuffer.append(stringArray[26]);
        stringBuffer.append('\n');
        stringBuffer.append("number of evaluated semantic predicates ");
        stringBuffer.append(stringArray[19]);
        stringBuffer.append('\n');
        stringBuffer.append("number of tokens ");
        stringBuffer.append(stringArray[20]);
        stringBuffer.append('\n');
        stringBuffer.append("number of hidden tokens ");
        stringBuffer.append(stringArray[21]);
        stringBuffer.append('\n');
        stringBuffer.append("number of char ");
        stringBuffer.append(stringArray[22]);
        stringBuffer.append('\n');
        stringBuffer.append("number of hidden char ");
        stringBuffer.append(stringArray[23]);
        stringBuffer.append('\n');
        stringBuffer.append("number of syntax errors ");
        stringBuffer.append(stringArray[24]);
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    protected int[] trim(int[] nArray, int n) {
        if (n < nArray.length) {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            nArray = nArray2;
        }
        return nArray;
    }

    protected int[] toArray(List list) {
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Integer n = (Integer)list.get(i);
            nArray[i] = n;
        }
        return nArray;
    }

    public int getNumberOfHiddenTokens(int n, int n2) {
        int n3 = 0;
        TokenStream tokenStream = this.parser.getTokenStream();
        for (int i = n; i < tokenStream.size() && i <= n2; ++i) {
            Token token = tokenStream.get(i);
            if (token.getChannel() == 0) continue;
            ++n3;
        }
        return n3;
    }
}

