/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel.nmr;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.impl.DefaultProducer;
import org.apache.servicemix.camel.nmr.ServiceMixEndpoint;
import org.apache.servicemix.nmr.api.Channel;
import org.apache.servicemix.nmr.api.Endpoint;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.api.Pattern;
import org.apache.servicemix.nmr.api.Status;
import org.apache.servicemix.nmr.api.service.ServiceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceMixProducer
extends DefaultProducer
implements Endpoint,
AsyncProcessor {
    private static final String TARGET_ENDPOINT_NAME = "TARGET_ENDPOINT_NAME";
    private final Map<String, Continuation> continuations = new ConcurrentHashMap<String, Continuation>();
    private final NMR nmr;
    private Channel channel;

    public ServiceMixProducer(ServiceMixEndpoint endpoint, NMR nmr) {
        super((org.apache.camel.Endpoint)endpoint);
        this.nmr = nmr;
    }

    public void process(org.apache.camel.Exchange exchange) throws Exception {
        NMR nmr = this.getEndpoint().getComponent().getNmr();
        Exchange e = this.getEndpoint().getComponent().getBinding().populateNmrExchangeFromCamelExchange(exchange, this.channel);
        try {
            e.setTarget(nmr.getEndpointRegistry().lookup(ServiceHelper.createMap((String[])new String[]{"NAME", this.getEndpoint().getEndpointName()})));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.channel.sendSync(e, this.getEndpoint().getTimeOut().longValue());
        this.handleResponse(exchange, this.channel, e);
    }

    public boolean process(org.apache.camel.Exchange exchange, AsyncCallback asyncCallback) {
        NMR nmr = this.getEndpoint().getComponent().getNmr();
        Exchange e = this.getEndpoint().getComponent().getBinding().populateNmrExchangeFromCamelExchange(exchange, this.channel);
        try {
            e.setTarget(nmr.getEndpointRegistry().lookup(ServiceHelper.createMap((String[])new String[]{"NAME", this.getEndpoint().getEndpointName()})));
            if (this.isSendSyncRequired()) {
                this.process(exchange);
                asyncCallback.done(true);
                return true;
            }
            this.continuations.put(e.getId(), new Continuation(exchange, asyncCallback));
            this.channel.send(e);
            return false;
        }
        catch (Exception ex) {
            this.log.warn("Error occured while sending NMR exchange", (Throwable)ex);
            this.continuations.remove(e.getId());
            exchange.setException((Throwable)ex);
            asyncCallback.done(true);
            return true;
        }
    }

    public void process(Exchange exchange) {
        Continuation continuation = this.continuations.remove(exchange.getId());
        if (continuation == null) {
            this.log.error("Unknown exchange received: " + exchange);
        } else {
            this.handleResponse(continuation.exchange, this.channel, exchange);
            continuation.callback.done(false);
        }
    }

    private void handleResponse(org.apache.camel.Exchange exchange, Channel client, Exchange e) {
        if (e.getError() != null) {
            this.handleErrorResponse(exchange, client, e);
        } else {
            this.handleSuccessResponse(exchange, client, e);
        }
    }

    private void handleSuccessResponse(org.apache.camel.Exchange exchange, Channel client, Exchange e) {
        if (e.getPattern() != Pattern.InOnly) {
            exchange.getProperties().putAll(e.getProperties());
            if (e.getFault().getBody() != null) {
                exchange.getOut().setFault(true);
                this.getEndpoint().getComponent().getBinding().copyNmrMessageToCamelMessage(e.getFault(), exchange.getOut());
            } else {
                this.getEndpoint().getComponent().getBinding().copyNmrMessageToCamelMessage(e.getOut(), exchange.getOut());
            }
            e.setStatus(Status.Done);
            this.channel.send(e);
        }
    }

    private void handleErrorResponse(org.apache.camel.Exchange camel, Channel client, Exchange nmr) {
        camel.setException((Throwable)nmr.getError());
    }

    protected void doStart() throws Exception {
        this.nmr.getEndpointRegistry().register((Endpoint)this, this.createEndpointMap());
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.nmr.getEndpointRegistry().unregister((Endpoint)this, this.createEndpointMap());
    }

    public ServiceMixEndpoint getEndpoint() {
        return (ServiceMixEndpoint)super.getEndpoint();
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    private Map<String, Object> createEndpointMap() {
        return ServiceHelper.createMap((String[])new String[]{"NAME", ServiceMixProducer.class.getName() + "-" + this.getEndpoint().getEndpointName(), TARGET_ENDPOINT_NAME, this.getEndpoint().getEndpointName()});
    }

    protected Map<String, Continuation> getContinuations() {
        return Collections.unmodifiableMap(this.continuations);
    }

    private boolean isSendSyncRequired() {
        return this.getEndpoint().getTimeOut() > 0L;
    }

    private final class Continuation {
        private final org.apache.camel.Exchange exchange;
        private final AsyncCallback callback;

        private Continuation(org.apache.camel.Exchange exchange, AsyncCallback callback) {
            this.exchange = exchange;
            this.callback = callback;
        }
    }
}

