/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms;

import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import org.apache.servicemix.common.BaseServiceUnitManager;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.DefaultServiceUnit;
import org.apache.servicemix.common.Deployer;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.util.IntrospectionSupport;
import org.apache.servicemix.common.util.URISupport;
import org.apache.servicemix.common.xbean.BaseXBeanDeployer;
import org.apache.servicemix.jms.JmsConfiguration;
import org.apache.servicemix.jms.JmsEndpoint;
import org.apache.servicemix.jms.JmsEndpointType;
import org.apache.servicemix.jms.JmsWsdl1Deployer;
import org.apache.servicemix.jms.endpoints.JmsConsumerEndpoint;
import org.apache.servicemix.jms.endpoints.JmsJcaConsumerEndpoint;
import org.apache.servicemix.jms.endpoints.JmsProviderEndpoint;

public class JmsComponent
extends DefaultComponent {
    protected JmsConfiguration configuration = new JmsConfiguration();
    protected JmsEndpointType[] endpoints;

    protected List getConfiguredEndpoints() {
        return JmsComponent.asList((Object[])this.endpoints);
    }

    protected Class[] getEndpointClasses() {
        return new Class[]{JmsEndpoint.class, JmsConsumerEndpoint.class, JmsProviderEndpoint.class, JmsJcaConsumerEndpoint.class};
    }

    public JmsConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(JmsConfiguration configuration) {
        this.configuration = configuration;
    }

    public JmsEndpointType[] getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(JmsEndpointType[] endpoints) {
        this.endpoints = endpoints;
    }

    public Object getKeystoreManager() {
        return this.configuration.getKeystoreManager();
    }

    public void setKeystoreManager(Object keystoreManager) {
        this.configuration.setKeystoreManager(keystoreManager);
    }

    public Object getAuthenticationService() {
        return this.configuration.getAuthenticationService();
    }

    public void setAuthenticationService(Object authenticationService) {
        this.configuration.setAuthenticationService(authenticationService);
    }

    protected Object getExtensionMBean() throws Exception {
        return this.configuration;
    }

    public BaseServiceUnitManager createServiceUnitManager() {
        Deployer[] deployers = new Deployer[]{new BaseXBeanDeployer((ServiceMixComponent)this, this.getEndpointClasses()), new JmsWsdl1Deployer(this)};
        return new BaseServiceUnitManager((ServiceMixComponent)this, deployers);
    }

    protected void doInit() throws Exception {
        String name;
        super.doInit();
        this.configuration.setRootDir(this.context.getWorkspaceRoot());
        this.configuration.setComponentName(this.context.getComponentName());
        this.configuration.load();
        if (this.configuration.getKeystoreManager() == null) {
            try {
                name = this.configuration.getKeystoreManagerName();
                Object km = this.context.getNamingContext().lookup(name);
                this.configuration.setKeystoreManager(km);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.configuration.getAuthenticationService() == null) {
            try {
                name = this.configuration.getAuthenticationServiceName();
                Object as = this.context.getNamingContext().lookup(name);
                this.configuration.setAuthenticationService(as);
            }
            catch (Exception e) {
                try {
                    Class<?> cl = Class.forName("org.apache.servicemix.jbi.security.auth.impl.JAASAuthenticationService");
                    this.configuration.setAuthenticationService(cl.newInstance());
                }
                catch (Throwable t) {
                    this.logger.warn("Unable to retrieve or create the authentication service");
                }
            }
        }
    }

    protected Endpoint getResolvedEPR(ServiceEndpoint ep) throws Exception {
        JmsEndpoint jmsEp = new JmsEndpoint(true);
        jmsEp.setServiceUnit((ServiceUnit)new DefaultServiceUnit(this.component));
        jmsEp.setService(ep.getServiceName());
        jmsEp.setEndpoint(ep.getEndpointName());
        jmsEp.setRole(MessageExchange.Role.PROVIDER);
        URI uri = new URI(ep.getEndpointName());
        Map map = URISupport.parseQuery((String)uri.getQuery());
        if (IntrospectionSupport.setProperties((Object)jmsEp, (Map)map, (String)"jms.")) {
            uri = URISupport.createRemainingURI((URI)uri, (Map)map);
        }
        if (uri.getPath() != null) {
            String path = uri.getSchemeSpecificPart();
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.startsWith("queue/")) {
                jmsEp.setDestinationStyle("queue");
                jmsEp.setJmsProviderDestinationName(path.substring("queue".length() + 1));
            } else if (path.startsWith("topic/")) {
                jmsEp.setDestinationStyle("topic");
                jmsEp.setJmsProviderDestinationName(path.substring("topic".length() + 1));
            }
        }
        return jmsEp;
    }
}

