/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.felix.eventadmin.impl.handler.EventHandlerProxy;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.util.tracker.ServiceTracker;

public class EventHandlerTracker
extends ServiceTracker {
    private volatile List matchingAllEvents = new ArrayList();
    private volatile Map matchingTopic = new HashMap();
    private volatile Map matchingPrefixTopic = new HashMap();
    private HandlerContext handlerContext;

    public EventHandlerTracker(BundleContext context) {
        super(context, EventHandler.class.getName(), null);
    }

    public void update(String[] ignoreTimeout, boolean requireTopic) {
        Matcher[] ignoreTimeoutMatcher;
        if (ignoreTimeout == null || ignoreTimeout.length == 0) {
            ignoreTimeoutMatcher = null;
        } else {
            ignoreTimeoutMatcher = new Matcher[ignoreTimeout.length];
            for (int i = 0; i < ignoreTimeout.length; ++i) {
                String value = ignoreTimeout[i];
                if (value != null) {
                    value = value.trim();
                }
                if (value == null || value.length() <= 0) continue;
                ignoreTimeoutMatcher[i] = value.endsWith(".") ? new PackageMatcher(value.substring(0, value.length() - 1)) : (value.endsWith("*") ? new SubPackageMatcher(value.substring(0, value.length() - 1)) : new ClassMatcher(value));
            }
        }
        this.handlerContext = new HandlerContext(this.context, ignoreTimeoutMatcher, requireTopic);
    }

    public Object addingService(ServiceReference reference) {
        EventHandlerProxy proxy = new EventHandlerProxy(this.handlerContext, reference);
        if (proxy.update()) {
            this.put(proxy);
        }
        return proxy;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        EventHandlerProxy proxy = (EventHandlerProxy)service;
        this.remove(proxy);
        if (proxy.update()) {
            this.put(proxy);
        }
    }

    public void removedService(ServiceReference reference, Object service) {
        EventHandlerProxy proxy = (EventHandlerProxy)service;
        this.remove(proxy);
        proxy.dispose();
    }

    private void updateMap(Map proxyListMap, String key, EventHandlerProxy proxy, boolean add) {
        ArrayList<EventHandlerProxy> proxies = (ArrayList<EventHandlerProxy>)proxyListMap.get(key);
        if (proxies == null) {
            if (!add) {
                return;
            }
            proxies = new ArrayList();
        } else {
            proxies = new ArrayList<EventHandlerProxy>(proxies);
        }
        if (add) {
            proxies.add(proxy);
        } else {
            proxies.remove(proxy);
        }
        if (proxies.size() == 0) {
            proxyListMap.remove(key);
        } else {
            proxyListMap.put(key, proxies);
        }
    }

    private synchronized void put(EventHandlerProxy proxy) {
        String[] topics = proxy.getTopics();
        if (topics == null) {
            ArrayList<EventHandlerProxy> newMatchingAllEvents = new ArrayList<EventHandlerProxy>(this.matchingAllEvents);
            newMatchingAllEvents.add(proxy);
            this.matchingAllEvents = newMatchingAllEvents;
        } else {
            HashMap newMatchingTopic = null;
            HashMap newMatchingPrefixTopic = null;
            for (int i = 0; i < topics.length; ++i) {
                String topic = topics[i];
                if (topic.endsWith("/*")) {
                    if (newMatchingPrefixTopic == null) {
                        newMatchingPrefixTopic = new HashMap(this.matchingPrefixTopic);
                    }
                    String prefix = topic.substring(0, topic.length() - 2);
                    this.updateMap(newMatchingPrefixTopic, prefix, proxy, true);
                    continue;
                }
                if (newMatchingTopic == null) {
                    newMatchingTopic = new HashMap(this.matchingTopic);
                }
                this.updateMap(newMatchingTopic, topic, proxy, true);
            }
            if (newMatchingTopic != null) {
                this.matchingTopic = newMatchingTopic;
            }
            if (newMatchingPrefixTopic != null) {
                this.matchingPrefixTopic = newMatchingPrefixTopic;
            }
        }
    }

    private synchronized void remove(EventHandlerProxy proxy) {
        String[] topics = proxy.getTopics();
        if (topics == null) {
            ArrayList newMatchingAllEvents = new ArrayList(this.matchingAllEvents);
            newMatchingAllEvents.remove(proxy);
            this.matchingAllEvents = newMatchingAllEvents;
        } else {
            HashMap newMatchingTopic = null;
            HashMap newMatchingPrefixTopic = null;
            for (int i = 0; i < topics.length; ++i) {
                String topic = topics[i];
                if (topic.endsWith("/*")) {
                    if (newMatchingPrefixTopic == null) {
                        newMatchingPrefixTopic = new HashMap(this.matchingPrefixTopic);
                    }
                    String prefix = topic.substring(0, topic.length() - 2);
                    this.updateMap(newMatchingPrefixTopic, prefix, proxy, false);
                    continue;
                }
                if (newMatchingTopic == null) {
                    newMatchingTopic = new HashMap(this.matchingTopic);
                }
                this.updateMap(newMatchingTopic, topic, proxy, false);
            }
            if (newMatchingTopic != null) {
                this.matchingTopic = newMatchingTopic;
            }
            if (newMatchingPrefixTopic != null) {
                this.matchingPrefixTopic = newMatchingPrefixTopic;
            }
        }
    }

    public Collection getHandlers(Event event) {
        List proxies;
        String topic = event.getTopic();
        HashSet handlers = new HashSet();
        handlers.addAll(this.matchingAllEvents);
        if (!this.matchingPrefixTopic.isEmpty()) {
            int pos = topic.lastIndexOf(47);
            while (pos != -1) {
                String prefix = topic.substring(0, pos);
                List proxies2 = (List)this.matchingPrefixTopic.get(prefix);
                if (proxies2 != null) {
                    handlers.addAll(proxies2);
                }
                pos = prefix.lastIndexOf(47);
            }
        }
        if ((proxies = (List)this.matchingTopic.get(topic)) != null) {
            handlers.addAll(proxies);
        }
        Iterator i = handlers.iterator();
        while (i.hasNext()) {
            EventHandlerProxy proxy = (EventHandlerProxy)i.next();
            if (proxy.canDeliver(event)) continue;
            i.remove();
        }
        return handlers;
    }

    static final class HandlerContext {
        public final BundleContext bundleContext;
        public final Matcher[] ignoreTimeoutMatcher;
        public final boolean requireTopic;

        public HandlerContext(BundleContext bundleContext, Matcher[] ignoreTimeoutMatcher, boolean requireTopic) {
            this.bundleContext = bundleContext;
            this.ignoreTimeoutMatcher = ignoreTimeoutMatcher;
            this.requireTopic = requireTopic;
        }
    }

    private static final class ClassMatcher
    implements Matcher {
        private final String m_className;

        public ClassMatcher(String name) {
            this.m_className = name;
        }

        public boolean match(String className) {
            return this.m_className.equals(className);
        }
    }

    private static final class SubPackageMatcher
    implements Matcher {
        private final String m_packageName;

        public SubPackageMatcher(String name) {
            this.m_packageName = name + '.';
        }

        public boolean match(String className) {
            int pos = className.lastIndexOf(46);
            return pos > -1 && className.substring(0, pos + 1).startsWith(this.m_packageName);
        }
    }

    private static final class PackageMatcher
    implements Matcher {
        private final String m_packageName;

        public PackageMatcher(String name) {
            this.m_packageName = name;
        }

        public boolean match(String className) {
            int pos = className.lastIndexOf(46);
            return pos > -1 && className.substring(0, pos).equals(this.m_packageName);
        }
    }

    static interface Matcher {
        public boolean match(String var1);
    }
}

